% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gf_interface.R
\name{gf_find}
\alias{gf_find}
\title{Motif finding: Searching the graph for structural patterns}
\usage{
gf_find(x, pattern)
}
\arguments{
\item{x}{An object coercable to a GraphFrame (typically, a
\code{gf_graphframe}).}

\item{pattern}{pattern specifying a motif to search for}
}
\description{
Motif finding uses a simple Domain-Specific Language (DSL) for
 expressing structural queries. For example,
 gf_find(g, "(a)-[e]->(b); (b)-[e2]->(a)") will search for
 pairs of vertices a,b connected by edges in both directions.
 It will return a DataFrame of all such structures in the graph,
 with columns for each of the named elements (vertices or edges)
 in the motif. In this case, the returned columns will be in
 order of the pattern: "a, e, b, e2."
}
\examples{
\dontrun{
gf_friends(sc) \%>\%
  gf_find("(a)-[e]->(b); (b)-[e2]->(a)")
}
}
