% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphical_evidence_rmatrix.R
\name{graphical_evidence_rmatrix}
\alias{graphical_evidence_rmatrix}
\title{Compute Marginal Likelihood using Graphical Evidence for Wishart,
BGL, and GHS}
\usage{
graphical_evidence_rmatrix(
  xx,
  burnin,
  nmc,
  prior_name = c("Wishart", "BGL", "GHS"),
  lambda = 0,
  alpha = 0,
  V = 0,
  print_progress = FALSE
)
}
\arguments{
\item{xx}{The input data specified by a user for which the marginal 
likelihood is to be calculated. This should be input as a matrix like object
with each individual sample of xx representing one row}

\item{burnin}{The number of iterations the MCMC sampler should iterate 
through and discard before beginning to save results}

\item{nmc}{The number of samples that the MCMC sampler should use to estimate
marginal likelihood}

\item{prior_name}{The name of the prior for which the marginal should be 
calculated, this is one of 'Wishart', 'BGL', 'GHS'}

\item{lambda}{A number specifying lambda for the priors of 'BGL' and 'GHS'
prior}

\item{alpha}{A number specifying alpha for the priors of 'Wishart'}

\item{V}{The scale matrix when specifying 'Wishart'}

\item{print_progress}{A boolean which indicates whether progress should be 
displayed on the console as each row of the telescoping sum is computed}
}
\value{
An estimate for the marginal likelihood under specified prior with
the specified parameters
}
\description{
Computes the marginal likelihood of input data xx under one of the following
priors: Wishart, Bayesian Graphical Lasso (BGL), and Graphical Horseshoe 
(GHS), specified under prior_name.
}
\examples{
# Compute the marginal likelihood of xx for GHS prior using 1,000 
# burnin and 5,000 sampled values at each call to the MCMC sampler
g_params <- gen_params_evidence('GHS')
marginal_results <- graphical_evidence_rmatrix(
  g_params$x_mat, 1e3, 5e3, 'GHS', lambda=1
)
}
