% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformation_functions.R
\name{mparetomargins}
\alias{mparetomargins}
\title{Marginalize multivariate Pareto dataset}
\usage{
mparetomargins(data, set_indices)
}
\arguments{
\item{data}{Numeric matrix \eqn{n\times d}{n x d}. A dataset containing
observations following a multivariate Pareto distribution.}

\item{set_indices}{Numeric vector with at most \eqn{d} different elements in
1, ..., \eqn{d}. The variables with respect to which to marginalize
the multivariate distribution.}
}
\value{
Numeric matrix \eqn{n\times m}{n x m}, where \eqn{m} is the length
of \code{set_indices}. Marginalized multivariate Pareto data.
}
\description{
Marginalize a multivariate Pareto dataset \code{data} with respect to the
variables in \code{set_indices}.
}
