% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_manipulate.R
\name{graph_manipulate}
\alias{graph_manipulate}
\alias{reorder_edges}
\title{Manipulate graph}
\usage{
reorder_edges(g, attr, desc = TRUE)
}
\arguments{
\item{g}{igraph object}

\item{attr}{edge attribute name used to sort edges}

\item{desc}{logical. sort in descending (default) or ascending order}
}
\value{
manipulated graph
}
\description{
functions to manipulate a graph
}
\details{
\code{reorder_edges()} allows to reorder edges according to an attribute so that edges are
drawn in the given order.
}
\examples{
library(igraph)

g <- sample_gnp(10, 0.5)
E(g)$attr <- 1:ecount(g)
gn <- reorder_edges(g,"attr")

}
\author{
David Schoch
}
