% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/month.R
\name{new_month}
\alias{new_month}
\alias{is_month}
\title{Minimal Constructor for a month object}
\usage{
new_month(x = integer(), n)

is_month(xx)
}
\arguments{
\item{x}{\verb{[integer]}

Vector representing the number of n-months since the Unix Epoch (1970-01-01).

\code{double} vectors will be converted via \code{as.integer(floor(x))}.}

\item{n}{\verb{[integer]}

Number of months that are being grouped. Must be greater than 1 (use
\code{yearmonth()} for this case).}

\item{xx}{\R object.}
}
\value{
A \verb{<grates_month>} object.
}
\description{
\code{new_month()} is a constructor for \verb{<grates_month>} objects aimed at
developers.
}
\details{
\code{grates_month} objects are stored as the integer number (starting at 0), of
n-month groups since the Unix Epoch (1970-01-01). Here n-months is taken to
mean a 'grouping of n consecutive months'.
}
\examples{
new_month(1:10, 2L)

}
\references{
The algorithm to convert between dates and months relative to the UNIX Epoch
comes from the work of Davis Vaughan in the unreleased
\href{https://github.com/DavisVaughan/datea/}{datea} package.
}
