% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yearweek.R
\name{new_yearweek}
\alias{new_yearweek}
\alias{is_yearweek}
\title{Minimal constructor for a yearweek object}
\usage{
new_yearweek(x = integer(), firstday = 1L)

is_yearweek(xx)
}
\arguments{
\item{x}{\verb{[integer]}

Vector representing the number of weeks.

\code{double} vectors will be converted via \code{as.integer(floor(x))}.}

\item{firstday}{\verb{[integer]}

The day the week starts on from 1 (Monday) to 7 (Sunday).}

\item{xx}{\R object.}
}
\value{
A \verb{<grates_yearweek>} object with subclass corresponding to the first
day of the week they represent (e.g. \verb{<grates_yearweek_monday>}).
}
\description{
\code{new_yearweek()} is a constructor for \verb{<grates_yearweek>} objects aimed at
developers.
}
\details{
\verb{<grates_yearweek>} objects are stored as the number of weeks
(starting at 0) from the date of the \code{firstday} nearest the Unix Epoch
(1970-01-01). That is, the number of seven day periods from:

\if{html}{\out{<div class="sourceCode">}}\preformatted{- 1969-12-29 for `firstday` equal to 1 (Monday)
- 1969-12-30 for `firstday` equal to 2 (Tuesday)
- 1969-12-31 for `firstday` equal to 3 (Wednesday)
- 1970-01-01 for `firstday` equal to 4 (Thursday)
- 1970-01-02 for `firstday` equal to 5 (Friday)
- 1970-01-03 for `firstday` equal to 6 (Saturday)
- 1970-01-04 for `firstday` equal to 7 (Sunday)
}\if{html}{\out{</div>}}
}
\examples{
new_yearweek(1:10)

}
\seealso{
\code{as_yearweek()}, \code{new_isoweek()} and \code{new_epiweek()}.
}
