% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnose.R
\name{appraise}
\alias{appraise}
\alias{appraise.gam}
\alias{appraise.lm}
\title{Model diagnostic plots}
\usage{
appraise(model, ...)

\method{appraise}{gam}(
  model,
  method = c("uniform", "simulate", "normal", "direct"),
  n_uniform = 10,
  n_simulate = 50,
  type = c("deviance", "pearson", "response"),
  n_bins = c("sturges", "scott", "fd"),
  ncol = NULL,
  nrow = NULL,
  guides = "keep",
  level = 0.9,
  ci_col = "black",
  ci_alpha = 0.2,
  point_col = "black",
  point_alpha = 1,
  line_col = "red",
  ...
)

\method{appraise}{lm}(model, ...)
}
\arguments{
\item{model}{a fitted model. Currently only class \code{"gam"}.}

\item{...}{arguments passed to \code{\link[patchwork:wrap_plots]{patchwork::wrap_plots()}}.}

\item{method}{character; method used to generate theoretical quantiles. Note
that \code{method = "direct"} is deprecated in favour of \code{method = "uniform"}.}

\item{n_uniform}{numeric; number of times to randomize uniform quantiles
in the direct computation method (\code{method = "direct"}) for QQ plots.}

\item{n_simulate}{numeric; number of data sets to simulate from the estimated
model when using the simulation method (\code{method = "simulate"}) for QQ
plots.}

\item{type}{character; type of residuals to use. Only \code{"deviance"},
\code{"response"}, and \code{"pearson"} residuals are allowed.}

\item{n_bins}{character or numeric; either the number of bins or a string
indicating how to calculate the number of bins.}

\item{ncol, nrow}{numeric; the numbers of rows and columns over which to
spread the plots.}

\item{guides}{character; one of \code{"keep"} (the default), \code{"collect"}, or
\code{"auto"}. Passed to \code{\link[patchwork:plot_layout]{patchwork::plot_layout()}}}

\item{level}{numeric; the coverage level for QQ plot reference intervals.
Must be strictly \verb{0 < level < 1}. Only used with \code{method = "simulate"}.}

\item{ci_alpha, ci_col}{numeric; the level of alpha transparency for the
QQ plot reference interval when \code{method = "simulate"}, or points drawn in
plots.}

\item{point_col, point_alpha}{colour and transparency used to draw points in
the plots. See \code{\link[graphics:par]{graphics::par()}} section \strong{Color Specification}. This is
passed to the individual plotting functions, and therefore affects the
points of all plots.}

\item{line_col}{colour specification for the 1:1 line in the QQ plot and the
reference line in the residuals vs linear predictor plot.}
}
\description{
Model diagnostic plots
}
\note{
The wording used in \code{\link[mgcv:qq.gam]{mgcv::qq.gam()}} uses \emph{direct} in reference to the
simulated residuals method (\code{method = "simulated"}). To avoid confusion,
\code{method = "direct"} is deprecated in favour of \code{method = "uniform"}.
}
\examples{
load_mgcv()
\dontshow{set.seed(2)}
## simulate some data...
dat <- gamSim(1, n = 400, dist = "normal", scale = 2)
mod <- gam(y ~ s(x0) + s(x1) + s(x2) + s(x3), data = dat)
## run some basic model checks
appraise(mod, point_col = "steelblue", point_alpha = 0.4)

## To change the theme for all panels use the & operator, for example to 
## change the ggplot theme for all panels
library("ggplot2")
appraise(mod, point_col = "steelblue", point_alpha = 0.4,
         line_col = "black") & theme_minimal()
}
\seealso{
The plots are produced by functions \code{\link[=qq_plot]{qq_plot()}},
\code{\link[=residuals_linpred_plot]{residuals_linpred_plot()}}, \code{\link[=residuals_hist_plot]{residuals_hist_plot()}},
and \code{\link[=observed_fitted_plot]{observed_fitted_plot()}}.
}
