% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/child_care_subsidy.R
\name{child_care_subsidy}
\alias{child_care_subsidy}
\title{Child Care Subsidy paid per child.}
\usage{
child_care_subsidy(
  family_annual_income = 0,
  activity_level = Inf,
  activity_exemption = FALSE,
  child_age = 3,
  type_of_day_care = c("cbdc", "oshc", "fdc", "ihc"),
  hours_day_care_fortnight = 36,
  cost_hour = 10,
  early_education_program = FALSE,
  cbdc_hourly_cap = 11.77,
  fdc_hourly_cap = 10.9,
  oshc_hourly_cap = 10.29,
  ihc_hourly_cap = 25.48,
  annual_cap_income = 186958,
  annual_cap_subsidy = 10190,
  income_test_bracket_1 = 66958,
  income_test_bracket_2 = 171958,
  income_test_bracket_3 = 251248,
  income_test_bracket_4 = 341248,
  income_test_bracket_5 = 354248,
  taper_1 = 0.85,
  taper_2 = 0.5,
  taper_3 = 0.2,
  activity_test_1_brackets = c(0, 8, 16.00001, 48.00001),
  activity_test_1_hours = c(0, 36, 72, 100)
)
}
\arguments{
\item{family_annual_income}{(numeric) Total income of the family.}

\item{activity_level}{(numeric) The total number of activity hours of the 
parent. Note that if there are two parents the one with the lower activity 
level will be applied. Common activities include work, leave, and study. A 
full list can be viewed at \url{https://guides.dss.gov.au/family-assistance-guide/3/5/2/10}.}

\item{activity_exemption}{(logical) Whether the parent is exempt from the 
activity test. Note that in a two parent family both parents must be exempt. 
A list of exemptions is available at \url{https://guides.dss.gov.au/family-assistance-guide/3/5/2/10}.}

\item{child_age}{(numeric) The age of the child in child care.}

\item{type_of_day_care}{(character) The type of child care. Acceptable inputs
are: \code{"cbdc"} Centre Based Day Care, "oshc" Outside School Hours Care,
\code{"fdc"} Family Day Care, or 
\code{"ihc"} In Home Care. Note that In Home Care 
can only be claimed once per family.}

\item{hours_day_care_fortnight}{(numeric) The number of hours of day care per
child per fortnight.}

\item{cost_hour}{(numeric) The cost of day care per hour.}

\item{early_education_program}{(logical) Whether the child is part of an 
early education program.}

\item{cbdc_hourly_cap, fdc_hourly_cap, oshc_hourly_cap, ihc_hourly_cap}{(numeric) 
The lower of `cost_hour` or the relevant `hourly_cap` will be used in the 
calculation of the subsidy.}

\item{annual_cap_income}{(numeric) The minimum family income for which the 
`annual_cap_subsidy` applies from.}

\item{annual_cap_subsidy}{(numeric) Amount at which annual subsidies are 
capped for those who earn more than `annual_cap_income`.}

\item{income_test_bracket_1, income_test_bracket_2, income_test_bracket_3, income_test_bracket_4, income_test_bracket_5}{(numeric) The steps at which income test 1 changes rates.
Note the strange structure \url{https://www.humanservices.gov.au/individuals/services/centrelink/child-care-subsidy/payments/how-your-income-affects-it}.}

\item{taper_1, taper_2, taper_3}{(numeric) The proportion of the hourly cap 
retained. Note that the rate only decreases between each odd bracket.}

\item{activity_test_1_brackets}{(numeric vector) The activity levels at which
the activity test increases.}

\item{activity_test_1_hours}{(numeric vector) The hours corresponding to the
step increase in `activity_test_1_brackets`.}
}
\value{
The annual child care subsidy payable per child.
}
\description{
Child Care Subsidy paid per child.
}
\examples{
child_care_subsidy(family_annual_income = 175000,
                   activity_level = 40,
                   activity_exemption = FALSE,
                   child_age = 3,
                   type_of_day_care = "cbdc",
                   cost_hour = 20,
                   hours_day_care_fortnight = 80,
                   early_education_program = FALSE)
                   
}
