% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generator.R
\name{rsbm}
\alias{rsbm}
\title{Generate a graph adjacency matrix using a Stochastic Block Model}
\usage{
rsbm(N, pi, mu)
}
\arguments{
\item{N}{The size of the graph to generate}

\item{pi}{A numeric vector of length K with clusters proportions (will be normalized to sum up to 1).}

\item{mu}{A numeric matrix of dim K x K with the connectivity pattern to generate. elements in [0,1].}
}
\value{
A list with fields:
\itemize{
\item x: the graph adjacency matrix as a \code{dgCMatrix}
\item K: number of generated clusters
\item N: number of vertex
\item cl: vector of clusters labels
\item pi: clusters proportions
\item mu: connectivity matrix
}
}
\description{
\code{rsbm} returns the adjacency matrix and the cluster labels generated randomly with a Stochastic Block Model.
}
\details{
This function takes the desired graph size, cluster proportions and connectivity matrix as input and sample a graph accordingly together with the clusters labels.
}
\examples{
simu = rsbm(100,rep(1/5,5),diag(rep(0.1,5))+0.001)
}
