% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_greek.R
\name{summary_greek}
\alias{summary_greek}
\title{Summarizing Linear Model Fits With Greek Letters}
\usage{
summary_greek(object, correlation = FALSE, symbolic.cor = FALSE, ...)
}
\arguments{
\item{object}{an object of class \code{"lm"}, usually, a result of a
    call to \code{\link[stats]{lm}}.}

\item{correlation}{logical; if \code{TRUE}, the correlation matrix of
    the estimated parameters is returned and printed.}

\item{symbolic.cor}{logical. If \code{TRUE}, print the correlations in
    a symbolic form (see \code{\link[stats]{symnum}}) rather than as numbers.}

\item{...}{
  Arguments passed on to \code{\link[stats:summary.lm]{stats::summary.lm}}
  \describe{
    \item{\code{}}{}
  }}
}
\value{
The function is like summary.lm but with Greek
letters in output.
}
\description{
summary method with Greek letters for class "lm".
}
\details{
It is recommended that the font size of the R console be increased for
better visualization of the symbols,
as some of the symbols are quite small.
}
\examples{
\donttest{
# Same example as summary.lm but with Greek letters
## Annette Dobson (1990) "An Introduction to Generalized Linear Models".
## Page 9: Plant Weight Data.
ctl <- c(4.17,5.58,5.18,6.11,4.50,4.61,5.17,4.53,5.33,5.14)
trt <- c(4.81,4.17,4.41,3.59,5.87,3.83,6.03,4.89,4.32,4.69)
group <- gl(2, 10, 20, labels = c("Ctl","Trt"))
weight <- c(ctl, trt)
lm.D9 <- lm(weight ~ group)
lm.D90 <- lm(weight ~ group - 1) # omitting intercept
coef(lm.D90)  # the bare coefficients
summary_greek(lm.D90 <- lm(weight ~ group -1))  # omitting intercept
 }
}
\seealso{
See \code{\link[stats]{summary.lm}} for more details.
}
\author{
Kévin Allan Sales Rodrigues.
}
