% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Malliavin_European_Greeks.R
\name{Malliavin_European_Greeks}
\alias{Malliavin_European_Greeks}
\title{This function calculates the fair value of an European option by with the
Malliavin Monte Carlo Method in the Black Scholes model.}
\usage{
Malliavin_European_Greeks(
  initial_price = 100,
  exercise_price = 100,
  r = 0,
  time_to_maturity = 1,
  volatility = 0.3,
  dividend_yield = 0,
  payoff = "call",
  greek = c("fair_value", "delta", "vega", "theta", "rho", "gamma"),
  model = "Black Scholes",
  paths = 10000,
  seed = 1,
  antithetic = FALSE
)
}
\arguments{
\item{initial_price}{\itemize{
\item initial price of the underlying asset.
}}

\item{exercise_price}{\itemize{
\item strike price of the option.
}}

\item{r}{\itemize{
\item risk-free interest rate.
}}

\item{time_to_maturity}{\itemize{
\item time to maturity.
}}

\item{volatility}{\itemize{
\item volatility of the underlying asset.
}}

\item{dividend_yield}{\itemize{
\item dividend yield.
}}

\item{payoff}{\itemize{
\item the payoff function, either a string in ("put", "call"), or a
function.
}}

\item{greek}{\itemize{
\item the greek to be calculated.
}}

\item{model}{\itemize{
\item the model to be chosen.
}}

\item{paths}{\itemize{
\item the number of simulated paths.
}}

\item{seed}{\itemize{
\item the seed of the random number generator
}}

\item{antithetic}{\itemize{
\item if TRUE, antithetic random numbers will be chosen to
decrease variance
}}
}
\value{
Named vector containing the values of the Greeks specified in the
parameter \code{greek}.
}
\description{
This function calculates the fair value of an European option by with the
Malliavin Monte Carlo Method in the Black Scholes model.
}
\examples{
Malliavin_European_Greeks(initial_price = 110, exercise_price = 100,
r = 0.02, time_to_maturity = 4.5, dividend_yield = 0.015, volatility = 0.22,
greek = c("fair_value", "delta", "rho"), payoff = "put")

}
