% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viseat.R
\name{viseat}
\alias{viseat}
\title{Process 'GreenFeed' Visits}
\arguments{
\item{file_path}{a character string or list representing files(s) with feedtimes from 'C-Lock Inc.'.}

\item{unit}{numeric or character vector or list representing one or more GreenFeed unit numbers.}

\item{start_date}{a character string representing the start date of the study (format: "mm/dd/yyyy")}

\item{end_date}{a character string representing the end date of the study (format: "mm/dd/yyyy")}

\item{rfid_file}{a character string representing the file with individual RFIDs.  The order should be Visual ID (col1) and RFID (col2)}
}
\value{
A list of two data frames:
  \item{visits_per_unit }{Data frame with daily processed 'GreenFeed' data, including columns for VisualID, Date, Time, number of drops, and visits.}
  \item{visits_per_animal }{Data frame with weekly processed 'GreenFeed' data, including columns for VisualID, total drops, total visits, mean drops, and mean visits.}
}
\description{
Processes 'GreenFeed' visits and food drops for a requested period.
     Generates a list of animals not visiting the 'GreenFeed' to manage them,
     and a description of animals visiting the 'GreenFeed'.
}
\examples{
# You should provide the feedtimes files.
# it could be a list of files if you have data from multiple units to combine
path <- list(system.file("extdata", "feedtimes.csv", package = "greenfeedr"))

# If the user include an rfid file, the structure should be in col1 AnimalName or VisualID, and
# col2 the RFID or TAG_ID. The file could be save in different formats (.xlsx, .csv, or .txt).
RFIDs <- system.file("extdata", "RFID_file.csv", package = "greenfeedr")

data <- viseat(
  file_path = path,
  unit = 1,
  start_date = "2024-05-13",
  end_date = "2024-05-25",
  rfid_file = RFIDs
)

}
