% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gr_confInt.R
\name{confInt}
\alias{confInt}
\alias{confInt.EKS}
\title{Confidence intervals for pairwise EC estimates}
\usage{
confInt(obj, ...)

\method{confInt}{EKS}(obj, evpo, k, level = 0.05, ...)
}
\arguments{
\item{obj}{is an object of class \code{EKS} which contains the estimates of the edge weights}

\item{...}{additional arguments}

\item{evpo}{is the matrix of evaluation points used in the EC estimator. It should contain only pairs of ones.}

\item{k}{is the number of upper order statistics. It should be the same as in the estimates of the edge weights.}

\item{level}{is the level of confidence. default is 0.05.}
}
\value{
A matrix with two columns for the lower and upper bounds for each of the coefficients.
}
\description{
Provides confidence intervals for the estimates using the ECE. It is suitable when only pairs are used -
pairwise extremal coefficients.
}
\examples{
seg<- make_tree(3, mode = "undirected")
seg<- set.vertex.attribute(seg, "name", V(seg), letters[1:3])
X<- matrix(rnorm(5*3), 5, 3) # create the dataset just to create the Tree object
colnames(X)<- letters[1:3]
tobj<- Tree(seg, X)
eks<- EKS(seg)
# assign any parameters, in practice these should be the estimates from the ECE
eks<- setParams(eks, c(0.1, 0.2, 0.3))
tup<- Tuples()
x<- rep(1, vcount(seg))
names(x)<- getNodesWithData(tobj)
coord<- evalPoints(tup, tobj, x)
# suppose that the estimates in deParams are obtained for k=100
confInt(eks, coord, 100)
}
