% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gr_evalPoints.R
\name{evalPoints}
\alias{evalPoints}
\alias{evalPoints.Coordinates}
\alias{evalPoints.RootDepSet}
\title{Matrix of coordinates}
\usage{
evalPoints(obj, ...)

\method{evalPoints}{Coordinates}(obj, obj2, x, ...)

\method{evalPoints}{RootDepSet}(obj, x, U, ...)
}
\arguments{
\item{obj}{Object of class \code{Tuples, Triples, Quadruples, Adjacent} which are subclasses of class
\code{Coordinates} or an object of class \code{RootDepSet}.}

\item{...}{additional arguments}

\item{obj2}{Object of class \code{Tree}}

\item{x}{A named vector of coordinates of length |U|, where U is the set of nodes with available data.}

\item{U}{The set of nodes with observable data}
}
\value{
An object of the same class as the argument \code{obj} containing a matrix of coordinates.
}
\description{
Generates a matrix of evaluation points, used by the extremal coefficients estimator.
}
\examples{
# create an object of class Adjacent
adjobj<- Adjacent()
# create a graph with named vertices
g<- graph(c("a", "b", "b", "c", "b", "d"), directed = FALSE)
# create a dataset with named columns
mydata<- matrix(rnorm(10*4), ncol=4, nrow=10)
colnames(mydata)<- get.vertex.attribute(g, "name", V(g))
# create object of class Network
mytree<- Tree(g, mydata)
# create the vector of coordinates and name it
x<- c(1:vcount(g))
names(x)<- c("a", "b", "c", "d")
# create the matrix of adjacent coordinates
mycoord<- evalPoints(adjobj, mytree, x)

# create a matrix of pair coordinates
mytup<- Tuples()
mytup<- evalPoints(mytup, mytree, x)

# create matrix of coordinates when there are missing data nodes
mydata<- matrix(rnorm(10*3), ncol=3, nrow=10)
colnames(mydata)<- c("b", "c", "d")
mytree<- Tree(g, mydata)
x<- c(1:vcount(g))
names(x)<- c("a", "b", "c", "d")
mytrip<- Triples()
evalPoints(mytrip, mytree, x)
# create a matrix of coordinates for an arbitrary subsets
rdsobj<- RootDepSet()
rds_values<- list(b=c("c", "d"), c=c("b", "d"), d=c("b", "c"))
rds_roots<- c("c", "d", "b")
rdsobj<- setRootDepSet(rdsobj, rds_values, rds_roots)
x<- c(2,3,4)
names(x)<- c("b", "c", "d")
evalPoints(rdsobj, x, getNodesWithData(mytree))
}
