% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reml_Iteration.R
\name{remlIt}
\alias{remlIt}
\alias{remlIt.default}
\alias{remlIt.gremlinR}
\title{Mixed-effect model Restricted Maximum Likelihood (REML) iterations.}
\usage{
remlIt(grMod, ...)

\method{remlIt}{default}(grMod, ...)

\method{remlIt}{gremlinR}(grMod, ...)
}
\arguments{
\item{grMod}{A gremlin model of class \code{grMod}. See \code{\link{gremlin}}
or \code{\link{gremlinSetup}} for the functions constructing an object
of class \code{grMod}.}

\item{\dots}{Additional arguments to be passed to control the model fitting.}
}
\value{
A \code{list} containing an object of class \code{grMod} and
  \code{matrix} containing details of the REML iterations (object
  \code{itMat}). See \code{\link{gremlin}} for descriptions of \code{grMod}
  and \code{itMat} objects.
}
\description{
Conduct REML iterations to estimate (co)variance parameters of a linear
  mixed-effect model (Gaussian responses).
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default method

\item \code{gremlinR}: gremlinR method
}}

\examples{
  grSsetp <- gremlinSetup(WWG11 ~ sex - 1, random = ~ sire, data = Mrode11)
  grS <- remlIt(grSsetp)

}
\author{
\email{matthewwolak@gmail.com}
}
