% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detector-dst-leap.R
\name{detectdst}
\alias{detectdst}
\alias{detectleap}
\title{DST and Leap year detector functions}
\usage{
detectdst(object)

detectleap(object)
}
\arguments{
\item{object}{Either a zoo / xts object or a vector of dates / times in POSIXt / Date
class.}
}
\value{
List containing:
\itemize{
\item start - data frame with id (number of observation) and the respective dates,
when the DST / leap year start;
\item end - data frame with id and dates, when DST / leap year end.
}
}
\description{
Functions to detect, when Daylight Saving Time and leap year start and finish
}
\details{
The \code{detectdst} function detects, when the change for the DST starts and ends.
The \code{detectleap} function does similar for the leap year, but flagging the 29th
of February as a starting and to the 28th of February next year as the ending dates.

In order for the methods to work, the object needs to be of either zoo / xts or POSIXt
class and should contain valid dates.
}
\examples{
# Generate matrix with monthly dummies for a zoo object
x <- as.POSIXct("2004-01-01")+0:(365*24*8)*60*60
detectdst(x)
detectleap(x)

}
\seealso{
\code{\link[greybox]{xregExpander}, \link[greybox]{temporaldummy},
\link[greybox]{outlierdummy}}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{models}
\keyword{nonlinear}
\keyword{regression}
\keyword{ts}
