% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/causal_forest.R
\name{causal_forest}
\alias{causal_forest}
\title{Causal forest}
\usage{
causal_forest(X, Y, W, sample.fraction = 0.5, mtry = NULL,
  num.trees = 2000, num.threads = NULL, min.node.size = NULL,
  honesty = TRUE, ci.group.size = 2, precompute.nuisance = TRUE,
  alpha = NULL, imbalance.penalty = NULL, stabilize.splits = TRUE,
  seed = NULL, clusters = NULL, samples_per_cluster = NULL,
  tune.parameters = FALSE, num.fit.trees = 40, num.fit.reps = 100,
  num.optimize.reps = 1000)
}
\arguments{
\item{X}{The covariates used in the causal regression.}

\item{Y}{The outcome.}

\item{W}{The treatment assignment (may be binary or real).}

\item{sample.fraction}{Fraction of the data used to build each tree.
Note: If honesty is used, these subsamples will
further be cut in half.}

\item{mtry}{Number of variables tried for each split.}

\item{num.trees}{Number of trees grown in the forest. Note: Getting accurate
confidence intervals generally requires more trees than
getting accurate predictions.}

\item{num.threads}{Number of threads used in training. If set to NULL, the software
automatically selects an appropriate amount.}

\item{min.node.size}{A target for the minimum number of observations in each tree leaf. Note that nodes
with size smaller than min.node.size can occur, as in the original randomForest package.}

\item{honesty}{Whether or not honest splitting (i.e., sub-sample splitting) should be used.}

\item{ci.group.size}{The forest will grow ci.group.size trees on each subsample.
In order to provide confidence intervals, ci.group.size must
be at least 2.}

\item{precompute.nuisance}{Should we first run regression forests to estimate
y(x) = E[Y|X=x] and w(x) = E[W|X=x], and then run a
causal forest on the residuals? This approach is
recommended, computational resources permitting.}

\item{alpha}{A tuning parameter that controls the maximum imbalance of a split.}

\item{imbalance.penalty}{A tuning parameter that controls how harshly imbalanced splits are penalized.}

\item{stabilize.splits}{Whether or not the treatment should be taken into account when
determining the imbalance of a split (experimental).}

\item{seed}{The seed of the C++ random number generator.}

\item{clusters}{Vector of integers or factors specifying which cluster each observation corresponds to.}

\item{samples_per_cluster}{If sampling by cluster, the number of observations to be sampled from
each cluster. Must be less than the size of the smallest cluster. If set to NULL
software will set this value to the size of the smallest cluster.#'}

\item{tune.parameters}{If true, NULL parameters are tuned by cross-validation; if false
NULL parameters are set to defaults.}

\item{num.fit.trees}{The number of trees in each 'mini forest' used to fit the tuning model.}

\item{num.fit.reps}{The number of forests used to fit the tuning model.}

\item{num.optimize.reps}{The number of random parameter values considered when using the model
to select the optimal parameters.}
}
\value{
A trained causal forest object.
}
\description{
Trains a causal forest that can be used to estimate
conditional average treatment effects tau(X). When
the treatment assignmnet W is binary and unconfounded,
we have tau(X) = E[Y(1) - Y(0) | X = x], where Y(0) and
Y(1) are potential outcomes corresponding to the two possible
treatment states. When W is continuous, we effectively estimate
an average partical effect Cov[Y, W | X = x] / Var[W | X = x],
and interpret it as a treatment effect given unconfoundedness.
}
\examples{
\dontrun{
# Train a causal forest.
n = 50; p = 10
X = matrix(rnorm(n*p), n, p)
W = rbinom(n, 1, 0.5)
Y = pmax(X[,1], 0) * W + X[,2] + pmin(X[,3], 0) + rnorm(n)
c.forest = causal_forest(X, Y, W)

# Predict using the forest.
X.test = matrix(0, 101, p)
X.test[,1] = seq(-2, 2, length.out = 101)
c.pred = predict(c.forest, X.test)

# Predict on out-of-bag training samples.
c.pred = predict(c.forest)

# Predict with confidence intervals; growing more trees is now recommended.
c.forest = causal_forest(X, Y, W, num.trees = 4000)
c.pred = predict(c.forest, X.test, estimate.variance = TRUE)
}

}
