% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/average_late.R
\name{average_late}
\alias{average_late}
\title{Estimate the average (conditional) local average treatment effect using a causal forest.}
\usage{
average_late(forest, compliance.score = NULL, subset = NULL)
}
\arguments{
\item{forest}{The trained forest.}

\item{compliance.score}{An estimate of the causal effect of Z on W,
i.e., Delta(X) = E[W | X, Z = 1] - E[W | X, Z = 0],
for each sample i = 1, ..., n.}

\item{subset}{Specifies subset of the training examples over which we
estimate the ATE. WARNING: For valid statistical performance,
the subset should be defined only using features Xi, not using
the instrument Zi, treatment Wi or outcome Yi.}
}
\value{
An estimate of the average (C)LATE, along with standard error.
}
\description{
Given an outcome Y, treatment W and instrument Z, the (conditional) local
average treatment effect is tau(x) = Cov[Y, Z | X = x] / Cov[W, Z | X = x].
This is the quantity that is estimated with an instrumental forest.
It can be intepreted causally in various ways. Given a homogeneity
assumption, tau(x) is simply the CATE at x. When W is binary
and there are no "defiers", Imbens and Angrist (1994) show that tau(x) can
be interpreted as an average treatment effect on compliers. This function
is about estimating tau = E[tau(X)] which, extending standard nomenclature,
should perhaps be called the Average (Conditional) Local Averate Treatment
Effect (ACLATE).
}
\details{
We estimate the ACLATE using a doubly robust estimator. See Chernozhukov
et al. (2016) for a discussion, and Section 5.2 of Athey and Wager (2017)
for an example using forests.

If clusters are specified for the forest, then each cluster gets equal weight.
For example, if there are 10 clusters with 1 unit each and per-cluster ATE = 1,
and there are 10 clusters with 19 units each and per-cluster ATE = 0, then the
overall ATE is 0.5 (not 0.05).
}
\references{
Aronow, Peter M., and Allison Carnegie. "Beyond LATE: Estimation
of the average treatment effect with an instrumental variable." Political
Analysis 21.4 (2013): 492-506.

Athey, Susan, and Stefan Wager. "Efficient policy learning."
arXiv preprint arXiv:1702.02896 (2017).

Chernozhukov, Victor, Juan Carlos Escanciano, Hidehiko Ichimura,
Whitney K. Newey, and James M. Robins. "Locally robust semiparametric
estimation." arXiv preprint arXiv:1608.00033 (2016).

Imbens, Guido W., and Joshua D. Angrist. "Identification and
Estimation of Local Average Treatment Effects." Econometrica 62.2 (1994): 467-475.
}
