% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pattern-geometry-wave.R
\name{grid.pattern_wave}
\alias{grid.pattern_wave}
\title{Wave patterned grobs}
\usage{
grid.pattern_wave(
  x = c(0, 0, 1, 1),
  y = c(1, 0, 0, 1),
  id = 1L,
  ...,
  colour = gp$col \%||\% "grey20",
  fill = gp$fill \%||\% "grey80",
  angle = 30,
  density = 0.2,
  spacing = 0.05,
  xoffset = 0,
  yoffset = 0,
  amplitude = 0.5 * spacing,
  frequency = 1/spacing,
  alpha = gp$alpha \%||\% NA_real_,
  linetype = gp$lty \%||\% 1,
  size = gp$lwd \%||\% 1,
  grid = "square",
  type = "triangle",
  default.units = "npc",
  name = NULL,
  gp = gpar(),
  draw = TRUE,
  vp = NULL
)
}
\arguments{
\item{x}{A numeric vector or unit object specifying x-locations of the pattern boundary.}

\item{y}{A numeric vector or unit object specifying y-locations of the pattern boundary.}

\item{id}{A numeric vector used to separate locations in x, y into multiple boundaries.
All locations within the same \code{id} belong to the same boundary.}

\item{...}{Currently ignored}

\item{colour}{Stroke colour}

\item{fill}{Fill colour}

\item{angle}{Rotation angle in degrees}

\item{density}{Approx. fraction of area the pattern fills.}

\item{spacing}{Spacing between repetitions of pattern ('snpc' units between 0 and 1).}

\item{xoffset}{Shift pattern along x axis ('snpc' units between 0 and 1).}

\item{yoffset}{Shift pattern along y axis ('snpc' units between 0 and 1).}

\item{amplitude}{Wave amplitude (\dQuote{snpc} units)}

\item{frequency}{Linear frequency (inverse \dQuote{snpc} units)}

\item{alpha}{Alpha (between 0 and 1) or \code{NA} (default, preserves colors' alpha value).}

\item{linetype}{Stroke linetype}

\item{size}{Stroke linewidth}

\item{grid}{Adjusts placement and density of certain graphical elements.
\code{"square"} (default) is a square grid.
\code{"hex"} is a hexagonal grid suitable for hexagonal and triangular tiling.
\code{"hex_circle"} is a hexagonal grid suitable for circle packing.}

\item{type}{Either \dQuote{sine} or \dQuote{triangle} (default).}

\item{default.units}{A string indicating the default units to use if \code{x} or \code{y}
are only given as numeric vectors.}

\item{name}{ A character identifier. }

\item{gp}{An object of class \code{"gpar"}, typically the output
    from a call to the function \code{\link[grid]{gpar}}.  This is basically
    a list of graphical parameter settings.}

\item{draw}{A logical value indicating whether graphics output
    should be produced.}

\item{vp}{A Grid viewport object (or NULL).}
}
\value{
A grid grob object invisibly.  If \code{draw} is \code{TRUE} then also draws to the graphic device as a side effect.
}
\description{
\code{grid.pattern_wave()} draws a wave pattern onto the graphic device.
}
\examples{
  if (require("grid")) {
    x_hex <- 0.5 + 0.5 * cos(seq(2 * pi / 4, by = 2 * pi / 6, length.out = 6))
    y_hex <- 0.5 + 0.5 * sin(seq(2 * pi / 4, by = 2 * pi / 6, length.out = 6))
    grid.newpage()
    grid.pattern_wave(x_hex, y_hex, colour = "black", type = "sine",
                      fill = c("red", "blue"), density = 0.4,
                      spacing = 0.15, angle = 0,
                      amplitude = 0.05, frequency = 1 / 0.20)

    # zig-zag pattern is a wave of `type` "triangle"
    grid.newpage()
    grid.pattern_wave(x_hex, y_hex, colour = "black", type = "triangle",
                        fill = c("red", "blue"), density = 0.4,
                        spacing = 0.15, angle = 0, amplitude = 0.075)

  }
}
\seealso{
Use \code{\link[=grid.pattern_stripe]{grid.pattern_stripe()}} for straight lines instead of waves.
}
