% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pattern-geometry-pch.R
\name{grid.pattern_pch}
\alias{grid.pattern_pch}
\title{Plotting character patterned grobs}
\usage{
grid.pattern_pch(
  x = c(0, 0, 1, 1),
  y = c(1, 0, 0, 1),
  id = 1L,
  ...,
  colour = gp$col \%||\% "grey20",
  fill = gp$fill \%||\% "grey80",
  angle = 30,
  density = 0.2,
  spacing = 0.05,
  xoffset = 0,
  yoffset = 0,
  scale = 0.5,
  shape = 1L,
  grid = "square",
  type = NULL,
  subtype = NULL,
  rot = 0,
  alpha = gp$alpha \%||\% NA_real_,
  linetype = gp$lty \%||\% 1,
  linewidth = size \%||\% gp$lwd \%||\% 1,
  size = NULL,
  default.units = "npc",
  name = NULL,
  gp = gpar(),
  draw = TRUE,
  vp = NULL
)
}
\arguments{
\item{x}{A numeric vector or unit object specifying x-locations of the pattern boundary.}

\item{y}{A numeric vector or unit object specifying y-locations of the pattern boundary.}

\item{id}{A numeric vector used to separate locations in x, y into multiple boundaries.
All locations within the same \code{id} belong to the same boundary.}

\item{...}{Currently ignored}

\item{colour}{Stroke colour}

\item{fill}{Fill colour}

\item{angle}{Rotation angle in degrees}

\item{density}{Approx. fraction of area the pattern fills.}

\item{spacing}{Spacing between repetitions of pattern ('snpc' units between 0 and 1).}

\item{xoffset}{Shift pattern along x axis ('snpc' units between 0 and 1).}

\item{yoffset}{Shift pattern along y axis ('snpc' units between 0 and 1).}

\item{scale}{For star polygons, multiplier (between 0 and 1)
applied to exterior radius to get interior radius.}

\item{shape}{An integer from \code{0} to \code{25} or \code{NA}.
See \code{\link[graphics:points]{graphics::points()}} for more details.
Note we only support these shapes and do not
support arbitrary ASCII / Unicode characters.}

\item{grid}{Adjusts placement and density of certain graphical elements.
\code{"square"} (default) is a square grid.
\code{"hex"} is a hexagonal grid suitable for hexagonal and triangular tiling.
\code{"hex_circle"} is a hexagonal grid suitable for circle packing.
\code{"elongated_triangle"} is a grid used for the "elongated triangle" tiling.}

\item{type}{Adjusts the repeating of certain aesthetics such as color.
Can use any type in \code{names_hex}, \code{names_square}, or \code{names_weave}.
See for \code{\link[=pattern_hex]{pattern_hex()}}, \code{\link[=pattern_square]{pattern_square()}}, and \code{\link[=pattern_weave]{pattern_weave()}} for
more information about supported \code{type} arguments.}

\item{subtype}{See for \code{\link[=pattern_hex]{pattern_hex()}}, \code{\link[=pattern_square]{pattern_square()}}, and \code{\link[=pattern_weave]{pattern_weave()}} for
more information about supported \code{subtype} arguments.}

\item{rot}{Angle to rotate regular polygon (degrees, counter-clockwise).}

\item{alpha}{Alpha (between 0 and 1) or \code{NA} (default, preserves colors' alpha value).}

\item{linetype}{Stroke linetype}

\item{linewidth}{Stroke linewidth}

\item{size}{For backwards compatibility can be used to set \code{linewidth}}

\item{default.units}{A string indicating the default units to use if \code{x} or \code{y}
are only given as numeric vectors.}

\item{name}{ A character identifier. }

\item{gp}{An object of class \code{"gpar"}, typically the output
    from a call to the function \code{\link[grid]{gpar}}.  This is basically
    a list of graphical parameter settings.}

\item{draw}{A logical value indicating whether graphics output
    should be produced.}

\item{vp}{A Grid viewport object (or NULL).}
}
\value{
A grid grob object invisibly.  If \code{draw} is \code{TRUE} then also draws to the graphic device as a side effect.
}
\description{
\code{grid.pattern_pch()} draws a plotting character pattern onto the graphic device.
}
\examples{
  if (require("grid")) {
    x_hex <- 0.5 + 0.5 * cos(seq(2 * pi / 4, by = 2 * pi / 6, length.out = 6))
    y_hex <- 0.5 + 0.5 * sin(seq(2 * pi / 4, by = 2 * pi / 6, length.out = 6))
    gp <- gpar(col = "black", fill = "lightblue")

    # pch 0-6 are simple shapes with no fill
    grid.pattern_pch(x_hex, y_hex, shape = 0:6, gp = gp,
                     spacing = 0.1, density = 0.4, angle = 0)

    # pch 7-14 are compound shapes with no fill
    grid.newpage()
    grid.pattern_pch(x_hex, y_hex, shape = 7:14, gp = gp,
                     spacing = 0.1, density = 0.4, angle = 0)

    # pch 15-20 are filled with 'col'
    grid.newpage()
    grid.pattern_pch(x_hex, y_hex, shape = 15:20, gp = gp,
                     spacing = 0.1, density = 0.4, angle = 0)

    # pch 21-25 are filled with 'fill'
    grid.newpage()
    grid.pattern_pch(x_hex, y_hex, shape = 21:25, gp = gp,
                     spacing = 0.1, density = 0.4, angle = 0)

    # using a 'basket' weave `type` with two shapes
    grid.newpage()
    grid.pattern_pch(x_hex, y_hex, shape = c(1,4), gp = gp,
                     type = "basket",
                     spacing = 0.1, density = 0.4, angle = 0)
  }
}
\seealso{
\code{\link[=grid.pattern_regular_polygon]{grid.pattern_regular_polygon()}} which is used to implement this pattern.
}
