% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_lift_vs_baseline.R
\name{estimate_lift_vs_baseline}
\alias{estimate_lift_vs_baseline}
\title{Estimate Lift vs Baseline}
\usage{
estimate_lift_vs_baseline(
  input_df,
  distribution,
  priors = list(),
  wrt_option,
  metric = "lift",
  threshold = 0.7
)
}
\arguments{
\item{input_df}{Dataframe containing option_name (str) and various other columns
depending on the distribution type. See vignette for more details.}

\item{distribution}{String of the distribution name}

\item{priors}{Optional list of priors. Defaults will be use otherwise.}

\item{wrt_option}{string the option loss is calculated with respect to (wrt). Required.}

\item{metric}{string the type of loss.
absolute will be the difference, on the outcome scale. 0 when best = wrt_option
lift will be the (best - wrt_option) / wrt_option, 0 when best = wrt_option
relative_risk will be the ratio best/wrt_option, 1 when best = wrt_option}

\item{threshold}{Lift percentage threshold between 0 and 1. (0.7
threshold is "at least 70\% lift"). Defaults to 0.7.}
}
\value{
numeric value remaining at the specified threshold
}
\description{
Estimate Lift vs Baseline
}
\examples{
input_df <- tibble::tibble(option_name = c("A", "B", "C"),
    sum_clicks = c(1000, 1000, 1000),
    sum_conversions = c(100, 120, 110))
estimate_lift_vs_baseline(input_df, distribution = "conversion_rate", wrt_option = "A")

}
