% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_from_posterior.R
\name{sample_from_posterior}
\alias{sample_from_posterior}
\title{Sample From Posterior}
\usage{
sample_from_posterior(
  input_df,
  distribution,
  priors = list(),
  n_samples = 50000
)
}
\arguments{
\item{input_df}{Dataframe containing option_name (str) and various other columns
depending on the distribution type. See vignette for more details.}

\item{distribution}{String of the distribution name}

\item{priors}{Optional list of priors. Defaults will be use otherwise.}

\item{n_samples}{Optional integer value. Defaults to 50,000 samples.}
}
\value{
A tibble with 2 columns: option_name (chr) and samples (dbl) [long form data].
}
\description{
Selects which function to use to sample from the posterior distribution
}
\examples{
input_df <- tibble::tibble(
   option_name = c("A", "B"),
   sum_clicks = c(1000, 1000),
   sum_conversions = c(100, 120),
   sum_sessions = c(1000, 1000),
   sum_revenue = c(1000, 1500)
)
sample_from_posterior(input_df, "conversion_rate")
sample_from_posterior(input_df, "rev_per_session")

}
