% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lm_effsize_ci.R
\name{lm_effsize_ci}
\alias{lm_effsize_ci}
\title{Confidence intervals for partial eta-squared and omega-squared for
linear models.}
\usage{
lm_effsize_ci(object, effsize = "eta", partial = TRUE,
  conf.level = 0.95, nboot = 500)
}
\arguments{
\item{object}{The linear model object (can be of class \code{lm}, \code{aov}, \code{anova}, or
\code{aovlist}).}

\item{effsize}{Character describing the effect size to be displayed: \code{"eta"}
(default) or \code{"omega"}.}

\item{partial}{Logical that decides if partial eta-squared or omega-squared
are returned (Default: \code{TRUE}). If \code{FALSE}, eta-squared or omega-squared
will be returned. Valid only for objects of class \code{lm}, \code{aov}, \code{anova}, or
\code{aovlist}.}

\item{conf.level}{Numeric specifying Level of confidence for the confidence
interval (Default: \code{0.95}).}

\item{nboot}{Number of bootstrap samples for confidence intervals for partial
eta-squared and omega-squared (Default: \code{500}).}
}
\value{
A dataframe with results from \code{stats::lm()} with partial eta-squared,
omega-squared, and bootstrapped confidence interval for the same.
}
\description{
This function will convert a linear model object to a dataframe
containing statistical details for all effects along with partial
eta-squared effect size and its confidence interval.
}
\examples{
# model
set.seed(123)
mod <-
  stats::aov(
    formula = mpg ~ wt + qsec + Error(disp / am),
    data = mtcars
  )

# dataframe with effect size and confidence intervals
groupedstats::lm_effsize_ci(mod)
}
\author{
Indrajeet Patil
}
