% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grouped_p_value.R
\name{grouped_p_value}
\alias{grouped_p_value}
\title{Extracting \emph{p}-values for models that don't produce them.}
\usage{
grouped_p_value(data, grouping.vars, ..f, ...)
}
\arguments{
\item{data}{Dataframe (or tibble) from which variables are to be taken.}

\item{grouping.vars}{Grouping variables.}

\item{..f}{A function, or function name as a string.}

\item{...}{<\link[rlang:dyn-dots]{dynamic}> Arguments for \code{.fn}.}
}
\description{
Extracting \emph{p}-values for models that don't produce them.
}
\examples{
groupedstats:::grouped_p_value(
  data = ggplot2::diamonds,
  formula = scale(price) ~ scale(carat) + (carat | color),
  grouping.vars = c(cut, clarity),
  ..f = lme4::lmer
)
}
\author{
Indrajeet Patil
}
\keyword{internal}
