% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{set_growR_verbosity}
\alias{set_growR_verbosity}
\title{Set verbosity of growR output.}
\usage{
set_growR_verbosity(level = 3)
}
\arguments{
\item{level}{Integer representing one of the following levels:
1: ERROR, 2: WARNING, 3: INFO, 4: DEBUG, 5: TRACE
Messages with a level higher than the specified \emph{level} are suppressed.
In other words, higher values of \emph{level} lead to more output and vice
versa.}
}
\value{
None Sets the option ``"growR.verbosity"`.
}
\description{
Set verbosity of growR output.
}
\examples{
# At level 3, only one of the three following messages are printed.
set_growR_verbosity(3)
logger("Message on level 5.", level = 5)
logger("Message on level 4.", level = 4)
logger("Message on level 3.", level = 3)
# At level 5, all three are printed.
set_growR_verbosity(5)
logger("Message on level 5.", level = 5)
logger("Message on level 4.", level = 4)
logger("Message on level 3.", level = 3)
# Reset to default.
set_growR_verbosity()

}
