% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{longwide}
\alias{longwide}
\title{Transform data in growthcleanr format into wide structure for BMI calculation}
\usage{
longwide(
  long_df,
  id = "id",
  subjid = "subjid",
  sex = "sex",
  agedays = "agedays",
  param = "param",
  measurement = "measurement",
  gcr_result = "gcr_result",
  include_all = FALSE,
  inclusion_types = c("Include")
)
}
\arguments{
\item{long_df}{A data frame to be transformed. Expects columns: id, subjid, sex, agedays, param, measurement, and gcr_result.}

\item{id}{name of observation ID column}

\item{subjid}{name of subject ID column}

\item{sex}{name of sex descriptor column}

\item{agedays}{name of age (in days) descriptor column}

\item{param}{name of parameter column to identify each type of measurement}

\item{measurement}{name of measurement column containing the actual measurement data}

\item{gcr_result}{name of column of results from growthcleanr::cleangrowth()}

\item{include_all}{Determines whether the function keeps all exclusion codes. If TRUE, all exclusion types are kept and the inclusion_types argument is ignored. Defaults to FALSE.}

\item{inclusion_types}{Vector indicating which exclusion codes from the cleaning algorithm should be included in the data, given that include_all is FALSE. For all options, see growthcleanr::cleangrowth(). Defaults to c("Include").}
}
\value{
Returns a data frame transformed from long to wide. Includes only values flagged with indicated inclusion types. Note that, for each subject, heights without corresponding weights for a given age (and vice versa) will be dropped.
}
\description{
\code{longwide} transforms data from long to wide format. Ideal for transforming output from growthcleanr::cleangrowth() into a format suitable for growthcleanr::ext_bmiz().
}
\examples{
# Run on a small subset of given data
df <- as.data.frame(syngrowth)
df <- df[df$subjid \%in\% unique(df[, "subjid"])[1:5], ]
df <- cbind(df,
            "gcr_result" = cleangrowth(df$subjid,
                                       df$param,
                                       df$agedays,
                                       df$sex,
                                       df$measurement))
# Convert to wide format
wide_df <- longwide(df)

# Include all inclusion types
wide_df <- longwide(df, include_all = TRUE)

# Specify all inclusion codes
wide_df <- longwide(df, inclusion_types = c("Include", "Exclude-Carried-Forward"))
}
