% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_formula_nonlin.R
\name{parse_formula_nonlin}
\alias{parse_formula_nonlin}
\title{Simple Formula Interface for Grouped Nonlinear Functions}
\usage{
parse_formula_nonlin(formula)
}
\arguments{
\item{formula}{a model formula specifying dependent and
independent variables, nonlinear model and grouping variables in the form:
\code{dependent ~ FUN(independent, parms) | group1 + group2 + ...}.
FUN can be a name of an existing growth model (e.g. \code{grow_logistic})
or a valid user-defined function (see \code{\link{growthmodel}}).}
}
\value{
a list with the elements \code{FUN}, \code{valuevar},  \code{timevar},
and \code{groups}
}
\description{
This simple formula interface handles formulae of the form
  \code{dependent ~ FUN(independent, parms) | group1 + group2 + ...}.
}
\details{
This function is used by \code{\link{all_growthmodels}} and normally not
  called for the user.
}
\examples{

ret <- parse_formula_nonlin(y ~ f(x, parms) | a + b + c)

}
\seealso{
\code{\link{multisplit}},  \code{\link{split}},  \code{\link{parse_formula}}
}
\keyword{internal}

