% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toInteger.R
\name{toInteger}
\alias{toInteger}
\title{Translate group sequential design to integer events (survival designs)
or sample size (other designs)}
\usage{
toInteger(x, ratio = 0, roundUpFinal = TRUE)
}
\arguments{
\item{x}{An object of class \code{gsDesign}.}

\item{ratio}{Integer indicating randomization ratio; not used for
time-to-event outcome; see details.}

\item{roundUpFinal}{Final value in returned \code{n.I} rounded up
if \code{TRUE}; otherwise, just rounded.}
}
\value{
An object of class \code{gsDesign} with integer vector for \code{n.I}.
}
\description{
Translate group sequential design to integer events (survival designs)
or sample size (other designs)
}
\details{
Note that if ratio is 0, rounding for \code{n.I} is done to the
nearest integer. For input x of class \code{gsSurv} (time-to-event outcome),
ratio is taken from the input \code{x} rather than the value provided
in the \code{ratio} argument.
For cases other than \code{gsSurv} class, rounding of final.
}
\examples{
# The following code derives the group sequential design using the method
# of Lachin and Foulkes

x <- gsSurv(
  k = 3,                 # 3 analyses
  test.type = 4,         # Non-binding futility bound 1 (no futility bound) and 4 are allowable
  alpha = .025,          # 1-sided Type I error
  beta = .1,             # Type II error (1 - power)
  timing = c(0.45, 0.7), # Proportion of final planned events at interims
  sfu = sfHSD,           # Efficacy spending function
  sfupar = -4,           # Parameter for efficacy spending function
  sfl = sfLDOF,          # Futility spending function; not needed for test.type = 1
  sflpar = 0,            # Parameter for futility spending function
  lambdaC = .001,        # Exponential failure rate
  hr = 0.3,              # Assumed proportional hazard ratio (1 - vaccine efficacy = 1 - VE)
  hr0 = 0.7,             # Null hypothesis VE
  eta = 5e-04,           # Exponential dropout rate
  gamma = 10,            # Piecewise exponential enrollment rates
  R = 16,                # Time period durations for enrollment rates in gamma
  T = 24,                # Planned trial duration
  minfup = 8,            # Planned minimum follow-up
  ratio = 3              # Randomization ratio (experimental:control)
)
# Convert bounds to exact binomial bounds
toInteger(x, ratio = 3)
}
