% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixed_design.R
\name{fixed_design}
\alias{fixed_design}
\title{Fixed design sample size}
\usage{
fixed_design(
  method = c("ahr", "fh", "mb", "lf", "rd", "maxcombo", "rmst", "milestone"),
  alpha = 0.025,
  power = NULL,
  ratio = 1,
  study_duration = 36,
  ...
)
}
\arguments{
\item{method}{Sample size method. Default is \code{"ahr"}.
Other options include \code{"fh"}, \code{"mb"}, \code{"lf"}, \code{"rd"},
\code{"maxcombo"}, \code{"milestone"}.}

\item{alpha}{One-sided Type I error (strictly between 0 and 1).}

\item{power}{Power (\code{NULL} to compute power or strictly between 0
and \code{1 - alpha} otherwise).}

\item{ratio}{Experimental:Control randomization ratio.}

\item{study_duration}{Study duration.}

\item{...}{Additional arguments like \code{enroll_rate}, \code{fail_rate},
\code{rho}, \code{gamma}, \code{tau}.}
}
\value{
A table.
}
\description{
Computes fixed design sample size for many sample size methods.
Returns a tibble with a basic summary.
}
\examples{
library(dplyr)

# Average hazard ratio
x <- fixed_design(
  "ahr",
  alpha = .025, power = .9,
  enroll_rate = tibble::tibble(stratum = "All", duration = 18, rate = 1),
  fail_rate = tibble::tibble(
    stratum = "All",
    duration = c(4, 100),
    fail_rate = log(2) / 12,
    hr = c(1, .6),
    dropout_rate = .001
  ),
  study_duration = 36
)
x \%>\% summary()

# Lachin and Foulkes (uses gsDesign::nSurv())
x <- fixed_design(
  "lf",
  alpha = .025, power = .9,
  enroll_rate = tibble::tibble(stratum = "All", duration = 18, rate = 1),
  fail_rate = tibble::tibble(
    stratum = "All",
    duration = 100,
    fail_rate = log(2) / 12,
    hr = .7,
    dropout_rate = .001
  ),
  study_duration = 36
)
x \%>\% summary()

# RMST
x <- fixed_design(
  "rmst",
  alpha = .025, power = .9,
  enroll_rate = tibble::tibble(stratum = "All", duration = 18, rate = 1),
  fail_rate = tibble::tibble(
    stratum = "All",
    duration = 100,
    fail_rate = log(2) / 12,
    hr = .7,
    dropout_rate = .001
  ),
  study_duration = 36,
  tau = 18
)
x \%>\% summary()

# Milestone
x <- fixed_design(
  "milestone",
  alpha = .025, power = .9,
  enroll_rate = tibble::tibble(stratum = "All", duration = 18, rate = 1),
  fail_rate = tibble::tibble(
    stratum = "All",
    duration = 100,
    fail_rate = log(2) / 12,
    hr = .7,
    dropout_rate = .001
  ),
  study_duration = 36,
  tau = 18
)
x \%>\% summary()
}
