% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/define.R
\name{define_fail_rate}
\alias{define_fail_rate}
\title{Define failure rate}
\usage{
define_fail_rate(duration, fail_rate, dropout_rate, hr = 1, stratum = "All")
}
\arguments{
\item{duration}{A numeric vector of ordered piecewise study duration interval.}

\item{fail_rate}{A numeric vector of failure rate in each \code{duration} in the control group.}

\item{dropout_rate}{A numeric vector of dropout rate in each \code{duration}.}

\item{hr}{A numeric vector of hazard ratio between treatment and control group.}

\item{stratum}{A character vector of stratum name.}
}
\value{
A \code{fail_rate} data frame.
}
\description{
Define subject failure rate for a study with two treatment groups.
Also supports stratified designs that have different failure rates in
each stratum.
}
\details{
Define the failure and dropout rate of subjects for a study as following
a piecewise exponential distribution.
The \code{duration} are ordered piecewise for a duration equal to
\eqn{t_i - t_{i-1}}, where \eqn{0 = t_0 < t_i < \cdots < t_M = \infty}.
The failure rate, dropout rate, and hazard ratio in a study duration
can be specified.

For a study with multiple strata, different duration, failure rates,
dropout rates, and hazard ratios can be specified in each stratum.
}
\examples{
# Define enroll rate
define_fail_rate(
  duration = c(3, 100),
  fail_rate = log(2) / c(9, 18),
  hr = c(.9, .6),
  dropout_rate = .001
)

# Define enroll rate with stratum
define_fail_rate(
  stratum = c(rep("Low", 2), rep("High", 2)),
  duration = 1,
  fail_rate = c(.1, .2, .3, .4),
  dropout_rate = .001,
  hr = c(.9, .75, .8, .6)
)
}
