% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.fixed_design}
\alias{summary.fixed_design}
\alias{summary.gs_design}
\title{Summary for fixed design or group sequential design objects}
\usage{
\method{summary}{fixed_design}(object, ...)

\method{summary}{gs_design}(
  object,
  analysis_vars = NULL,
  analysis_decimals = NULL,
  col_vars = NULL,
  col_decimals = NULL,
  bound_names = c("Efficacy", "Futility"),
  ...
)
}
\arguments{
\item{object}{A design object returned by fixed_design_xxx() and gs_design_xxx().}

\item{...}{Additional parameters (not used).}

\item{analysis_vars}{The variables to be put at the summary header of each analysis.}

\item{analysis_decimals}{The displayed number of digits of \code{analysis_vars}.
If the vector is unnamed, it must match the length of \code{analysis_vars}. If
the vector is named, you only have to specify the number of digits for the
variables you want to be displayed differently than the defaults.}

\item{col_vars}{The variables to be displayed.}

\item{col_decimals}{The decimals to be displayed for the displayed variables in \code{col_vars}.
If the vector is unnamed, it must match the length of \code{col_vars}. If the
vector is named, you only have to specify the number of digits for the
columns you want to be displayed differently than the defaults.}

\item{bound_names}{Names for bounds; default is \code{c("Efficacy", "Futility")}.}
}
\value{
A summary table (data frame).
}
\description{
Summary for fixed design or group sequential design objects
}
\examples{
library(dplyr)

# Enrollment rate
enroll_rate <- define_enroll_rate(
  duration = 18,
  rate = 20
)

# Failure rates
fail_rate <- define_fail_rate(
  duration = c(4, 100),
  fail_rate = log(2) / 12,
  hr = c(1, .6),
  dropout_rate = .001
)

# Study duration in months
study_duration <- 36

# Experimental / Control randomization ratio
ratio <- 1

# 1-sided Type I error
alpha <- 0.025
# Type II error (1 - power)
beta <- 0.1

# AHR ----
# under fixed power
fixed_design_ahr(
  alpha = alpha,
  power = 1 - beta,
  enroll_rate = enroll_rate,
  fail_rate = fail_rate,
  study_duration = study_duration,
  ratio = ratio
) \%>\% summary()

# FH ----
# under fixed power
fixed_design_fh(
  alpha = alpha,
  power = 1 - beta,
  enroll_rate = enroll_rate,
  fail_rate = fail_rate,
  study_duration = study_duration,
  ratio = ratio
) \%>\% summary()

# Design parameters ----
library(gsDesign)
library(gsDesign2)
library(dplyr)

# enrollment/failure rates
enroll_rate <- define_enroll_rate(
  stratum = "All",
  duration = 12,
  rate = 1
)
fail_rate <- define_fail_rate(
  duration = c(4, 100),
  fail_rate = log(2) / 12,
  hr = c(1, .6),
  dropout_rate = .001
)

# Information fraction
info_frac <- (1:3) / 3

# Analysis times in months; first 2 will be ignored as info_frac will not be achieved
analysis_time <- c(.01, .02, 36)

# Experimental / Control randomization ratio
ratio <- 1

# 1-sided Type I error
alpha <- 0.025

# Type II error (1 - power)
beta <- .1

# Upper bound
upper <- gs_spending_bound
upar <- list(sf = gsDesign::sfLDOF, total_spend = 0.025, param = NULL, timing = NULL)

# Lower bound
lower <- gs_spending_bound
lpar <- list(sf = gsDesign::sfHSD, total_spend = 0.1, param = 0, timing = NULL)

# weight function in WLR
wgt00 <- function(x, arm0, arm1) {
  wlr_weight_fh(x, arm0, arm1, rho = 0, gamma = 0)
}
wgt05 <- function(x, arm0, arm1) {
  wlr_weight_fh(x, arm0, arm1, rho = 0, gamma = .5)
}

# test in COMBO
fh_test <- rbind(
  data.frame(rho = 0, gamma = 0, tau = -1, test = 1, analysis = 1:3, analysis_time = c(12, 24, 36)),
  data.frame(rho = c(0, 0.5), gamma = 0.5, tau = -1, test = 2:3, analysis = 3, analysis_time = 36)
)

# Example 1 ----
\donttest{
x_ahr <- gs_design_ahr(
  enroll_rate = enroll_rate,
  fail_rate = fail_rate,
  info_frac = info_frac, # Information fraction
  analysis_time = analysis_time,
  ratio = ratio,
  alpha = alpha,
  beta = beta,
  upper = upper,
  upar = upar,
  lower = lower,
  lpar = lpar
)

x_ahr \%>\% summary()

# Customize the digits to display
x_ahr \%>\% summary(analysis_vars = c("time", "event", "info_frac"), analysis_decimals = c(1, 0, 2))

# Customize the labels of the crossing probability
x_ahr \%>\% summary(bound_names = c("A is better", "B is better"))

# Customize the variables to be summarized for each analysis
x_ahr \%>\% summary(analysis_vars = c("n", "event"), analysis_decimals = c(1, 1))

# Customize the digits for the columns
x_ahr \%>\% summary(col_decimals = c(z = 4))

# Customize the columns to display
x_ahr \%>\% summary(col_vars = c("z", "~hr at bound", "nominal p"))

# Customize columns and digits
x_ahr \%>\% summary(col_vars = c("z", "~hr at bound", "nominal p"),
                  col_decimals = c(4, 2, 2))
}

# Example 2 ----
\donttest{
x_wlr <- gs_design_wlr(
  enroll_rate = enroll_rate,
  fail_rate = fail_rate,
  weight = wgt05,
  info_frac = NULL,
  analysis_time = sort(unique(x_ahr$analysis$time)),
  ratio = ratio,
  alpha = alpha,
  beta = beta,
  upper = upper,
  upar = upar,
  lower = lower,
  lpar = lpar
)
x_wlr \%>\% summary()
}
# Maxcombo ----
\donttest{
x_combo <- gs_design_combo(
  ratio = 1,
  alpha = 0.025,
  beta = 0.2,
  enroll_rate = define_enroll_rate(duration = 12, rate = 500 / 12),
  fail_rate = tibble::tibble(
    stratum = "All",
    duration = c(4, 100),
    fail_rate = log(2) / 15, hr = c(1, .6), dropout_rate = .001
  ),
  fh_test = fh_test,
  upper = gs_spending_combo,
  upar = list(sf = gsDesign::sfLDOF, total_spend = 0.025),
  lower = gs_spending_combo,
  lpar = list(sf = gsDesign::sfLDOF, total_spend = 0.2)
)
x_combo \%>\% summary()
}
# Risk difference ----
\donttest{
gs_design_rd(
  p_c = tibble::tibble(stratum = "All", rate = .2),
  p_e = tibble::tibble(stratum = "All", rate = .15),
  info_frac = c(0.7, 1),
  rd0 = 0,
  alpha = .025,
  beta = .1,
  ratio = 1,
  stratum_prev = NULL,
  weight = "unstratified",
  upper = gs_b,
  lower = gs_b,
  upar = gsDesign::gsDesign(
    k = 3, test.type = 1, sfu = gsDesign::sfLDOF, sfupar = NULL
  )$upper$bound,
  lpar = c(qnorm(.1), rep(-Inf, 2))
) \%>\% summary()
}
}
