% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freqs.R
\name{freqs}
\alias{freqs}
\alias{freqs.default}
\alias{freqs.Arma}
\alias{freqs.Ma}
\alias{freqs.Sos}
\alias{freqs.Zpg}
\title{Frequency response of analog filters}
\usage{
freqs(filt, ...)

\method{freqs}{default}(filt, a, w, plot = TRUE, ...)

\method{freqs}{Arma}(filt, w, ...)

\method{freqs}{Ma}(filt, w, ...)

\method{freqs}{Sos}(filt, w, ...)

\method{freqs}{Zpg}(filt, w, ...)
}
\arguments{
\item{filt}{for the default case, moving average (MA) polynomial
coefficients, specified as a numeric vector or matrix. In case of a matrix,
then each row corresponds to an output of the system. The number of columns
of \code{b} must be less than or equal to the length of \code{a}.}

\item{...}{additional parameters (not used)}

\item{a}{autoregressive (AR) polynomial coefficients, specified as a vector.}

\item{w}{angular frequencies, specified as a positive real vector expressed
in rad/second.}

\item{plot}{logical. If \code{TRUE} (default), plots the magnitude and phase
responses as a function of angular frequency, otherwise a vector of the
frequency response is returned.}
}
\value{
Frequency response, returned as a complex vector.
}
\description{
Compute the s-plane frequency response of an IIR filter.
}
\details{
The s-plane frequency response of the IIR filter \code{B(s) / A(s)} is
computed as \code{H = polyval(B, 1i * W) / polyval(A, 1i * W)}. If called
with no output argument, a plot of magnitude and phase are displayed.
}
\examples{
b <- c(1, 2); a <- c(1, 1)
w <- seq(0, 4, length.out = 128)
freqs (b, a, w)

}
\author{
Julius O. Smith III, \email{jos@ccrma.stanford.edu}.\cr
Conversion to R by Geert van Boxtel \email{gjmvanboxtel@gmail.com}
}
