% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pad.R
\name{pad}
\alias{pad}
\alias{prepad}
\alias{postpad}
\title{Pad data}
\usage{
pad(x, l, c = 0, MARGIN = 2, direction = c("both", "pre", "post"))

prepad(x, l, c = 0, MARGIN = 2)

postpad(x, l, c = 0, MARGIN = 2)
}
\arguments{
\item{x}{Vector or matrix to be padded}

\item{l}{Length of output data along the padding dimension. If \code{length
(x) > l}, elements from the beginning (\code{dimension = "pre"}) or the end
(\code{direction = "post"}) of \code{x} are removed until a vector of
length \code{l} is obtained. If \code{direction = "both"}, values are
removed from both ends, and in case of an uneven length the smallest number
of elements is removed from the beginning of vector.}

\item{c}{Value to be used for the padding (scalar). Must be of the same type
as the elements in \code{x}. Default: 0}

\item{MARGIN}{A vector giving the subscripts which the function will be
applied over. E.g., for a matrix 1 indicates rows, 2 indicates columns,
c(1, 2) indicates rows and columns. Where \code{x} has named dimnames, it
can be a character vector selecting dimension names.  If \code{MARGIN} is
larger than the dimensions of \code{x}, the result will have \code{MARGIN}
dimensions. Default: 2 (columns).}

\item{direction}{Where to pad the array along each dimension. One of the
  following:
\describe{
  \item{"pre"}{Before the first element}
  \item{"post"}{After the last element}
  \item{"both"}{(default) Before the first and after the last element}
}}
}
\value{
Padded data, returned as a vector or matrix.
}
\description{
Pre- or postpad the data object \code{x} with the value \code{c} until it is
of length \code{l}.
}
\examples{
v <- 1:24
res <- postpad(v, 30)
res <- postpad(v, 20)
res <- prepad(v, 30)
res <- prepad(v, 20)

m <- matrix(1:24, 4, 6)
res <- postpad(m, 8, 100)
res <- postpad(m, 8, 100, MARGIN = 1)
res <- prepad(m, 8, 100)
res <- prepad(m, 8, 100, MARGIN = 1)

res <- postpad(m, 2)
res <- postpad(m, 2, MARGIN = 1)
res <- prepad(m, 2)
res <- prepad(m, 2, MARGIN = 1)

}
\author{
Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
