% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idct.R
\name{idct}
\alias{idct}
\title{Inverse Discrete Cosine Transform}
\usage{
idct(x, n = NROW(x))
}
\arguments{
\item{x}{input discrete cosine transform, specified as a numeric vector or
matrix. In case of a vector it represents a single signal; in case of a
matrix each column is a signal.}

\item{n}{transform length, specified as a positive integer scalar. Default:
\code{NROW(x)}.}
}
\value{
Inverse discrete cosine transform, returned as a vector or matrix.
}
\description{
Compute the inverse unitary discrete cosine transform of a signal.
}
\details{
The discrete cosine transform (DCT) is closely related to the discrete
Fourier transform. You can often reconstruct a sequence very accurately from
only a few DCT coefficients. This property is useful for applications
requiring data reduction.
}
\examples{
x <- seq_len(100) + 50 * cos(seq_len(100) * 2 * pi / 40)
X <- dct(x)

# Find which cosine coefficients are significant (approx.)
# zero the rest
nsig <- which(abs(X) < 1)
N <- length(X) - length(nsig) + 1
X[nsig] <- 0

# Reconstruct the signal and compare it to the original signal.
xx <- idct(X)
plot(x, type = "l")
lines(xx, col = "red")
legend("bottomright", legend = c("Original", paste("Reconstructed, N =", N)),
       lty = 1, col = 1:2)

}
\seealso{
\code{\link{dct}}
}
\author{
Paul Kienzle, \email{pkienzle@users.sf.net}.\cr
Conversion to R by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
