% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cheb.R
\name{cheb}
\alias{cheb}
\title{Chebyshev polynomials}
\usage{
cheb(n, x)
}
\arguments{
\item{n}{Order of the polynomial, specified as a positive integer.}

\item{x}{Point or points at which to calculate the Chebyshev polynomial}
}
\value{
Polynomial of order \code{x}, evaluated at point(s) \code{x}.
}
\description{
Return the value of the Chebyshev polynomial at specific points.
}
\details{
The Chebyshev polynomials are defined by the equations:
\if{latex}{
  \deqn{Tn(x) = cos(n \cdot acos(x),    |x|<= 1}
  \deqn{Tn(x) = cosh(n \cdot acosh(x),  |x|> 1}
}
\if{html}{\preformatted{
  Tn(x) = cos(n . acos(x),    |x|<= 1
  Tn(x) = cosh(n . acosh(x),  |x|> 1
}}
If \code{x} is a vector, the output is a vector of the same size, where each
element is calculated as \eqn{y(i) = Tn(x(i))}.
}
\examples{

cp <- cheb(5, 1)
cp <- cheb(5, c(2,3))

}
\author{
André Carezia, \email{acarezia@uol.com.br}.\cr Conversion to R by
  Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
