% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ultrwin.R
\name{ultrwin}
\alias{ultrwin}
\title{Ultraspherical window}
\usage{
ultrwin(n, mu = 3, xmu = 1)
}
\arguments{
\item{n}{Window length, specified as a positive integer.}

\item{mu}{parameter that controls the side-lobe roll-off ratio. Default: 3.}

\item{xmu}{parameters that provides a trade-off between the ripple ratio and
a width characteristic. Default: 1}
}
\value{
ultraspherical window, returned as a vector.
}
\description{
Return the coefficients of an ultraspherical window
}
\note{
The Dolph-Chebyshev and Saramaki windows are special cases of the
  Ultraspherical window, with mu set to 0 and 1, respectively.
}
\examples{

w <- ultrwin(101, 3, 1)
plot (w, type = "l", xlab = "Samples", ylab =" Amplitude")
freqz(w)

w2 <- ultrwin(101, 2, 1)
f2 <- freqz(w2)
w3 <- ultrwin(101, 3, 1)
f3 <- freqz(w3)
w4 <- ultrwin(101, 4, 1)
f4 <- freqz(w4)
op <- par(mfrow = c(2, 1))
plot(w2, type = "l", col = "black", xlab = "", ylab = "")
lines(w3, col = "red")
lines(w4, col = "blue")
legend("topright", legend = 2:4, col = c("black", "red", "blue"), lty = 1)
plot (f2$w, 20 * log10(abs(f2$h)), type = "l", col = "black",
      xlab = "", ylab = "", ylim = c(-100, 50))
lines(f3$w, 20 * log10(abs(f3$h)), col = "red")
lines(f4$w, 20 * log10(abs(f4$h)), col = "blue")
legend("topright", legend = 2:4, col = c("black", "red", "blue"), lty = 1)
par(op)
title(main = "Effect of increasing the values of mu (xmu = 1)")

w1 <- ultrwin(101, 2, 1)
f1 <- freqz(w1)
w2 <- ultrwin(101, 2, 1.001)
f2 <- freqz(w2)
w3 <- ultrwin(101, 2, 1.002)
f3 <- freqz(w3)
op <- par(mfrow = c(2, 1))
plot(w1, type = "l", col = "black", xlab = "", ylab = "")
lines(w2, col = "red")
lines(w3, col = "blue")
legend("topright", legend = 2:4, col = c("black", "red", "blue"), lty = 1)
plot (f1$w, 20 * log10(abs(f1$h)), type = "l", col = "black",
      xlab = "", ylab = "", ylim = c(-100, 50))
lines(f2$w, 20 * log10(abs(f2$h)), col = "red")
lines(f3$w, 20 * log10(abs(f3$h)), col = "blue")
legend("topright", legend = c(1, 1.001, 1.002),
       col = c("black", "red", "blue"), lty = 1)
par(op)
title(main = "Effect of increasing the values of xmu (mu = 2)")

}
\references{
[1] Bergen, S.W.A., and Antoniou, A. Design of Ultraspherical
  Window Functions with Prescribed Spectral Characteristics. EURASIP Journal
  on Applied Signal Processing 2004:13, 2053–2065.
}
\author{
Geert van Boxtel \email{G.J.M.vanBoxtel@gmail.com}.
}
