% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raw.R
\name{check_raw}
\alias{check_raw}
\title{Check raw data}
\usage{
check_raw(raw, plot = TRUE, thresh = 0, ...)
}
\arguments{
\item{raw}{Matrix with raw data.
Two consecutive columns per sample.
The order (e.g. green,red) must be consistent for all samples.}

\item{plot}{Logical. If TRUE data will be plotted.}

\item{thresh}{Threshold for filtering.}

\item{...}{arguments are forwarded to \code{hist()}.}
}
\value{
Vector containing Samples below threshold.
}
\description{
Before preprocessing it is advised to check the data for failed samples.
This function allows to visualize the signals and return sample indices of failed samples.
}
\examples{
if(require(brassicaData)){
data("raw_napus", package = "brassicaData", envir = environment())
to_filter <- check_raw(raw_napus, thresh = 28000, breaks = 20)
}
}

