% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{filter_cnv}
\alias{filter_cnv}
\title{Filter Copy number variations}
\usage{
filter_cnv(dat, thresh = 5)
}
\arguments{
\item{dat}{norm_data object.}

\item{thresh}{Integer, lower threshold for filtering CNVs.}
}
\value{
norm_data object
}
\description{
Short CNV stretches can be filtered out.
}
\examples{
\dontrun{
if(require(brassicaData)){
data("raw_napus", package = "brassicaData", envir = environment())
dat <- intens_theta(raw_napus)
dat <- remove_suffix(dat, "_Grn")
dat <- geno_baf_rratio(dat, delthresh = 11)
dat <- segm(dat)
dat <- cnv(dat, dup = 0.03, del = -0.06)
dat <- filter_cnv(dat)
}
}
}

