% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_Sstar_from_SP}
\alias{gsw_Sstar_from_SP}
\title{Convert from Practical Salinity to Preformed Salinity}
\usage{
gsw_Sstar_from_SP(SP, p, longitude, latitude)
}
\arguments{
\item{SP}{Practical Salinity (PSS-78) [ unitless ]}

\item{p}{sea pressure [ dbar ]}

\item{longitude}{longitude in decimal degrees [ 0 to 360 or -180 to 180]}

\item{latitude}{latitude in decimal degrees [ -90 to 90 ]}
}
\value{
Preformed Salinity [ g/kg ]
}
\description{
Calculate Preformed Salinity from Practical Salinity, pressure,
longitude, and latitude.
}
\details{
If SP is a matrix and if its dimensions correspond to the
lengths of longitude and latitude, then the latter are
converted to analogous matrices with \code{\link{expand.grid}}.
}
\examples{
gsw_Sstar_from_SP(34.5487, 10, 188, 4) # 34.711553680880769
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_Sstar_from_SP.html}
}
\seealso{
\code{\link{gsw_SP_from_Sstar}} does the reverse; \code{\link{gsw_Sstar_from_SA}} is similar.
}

