% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_pressure_freezing_CT}
\alias{gsw_pressure_freezing_CT}
\title{Pressure at which Seawater Freezes}
\usage{
gsw_pressure_freezing_CT(SA, CT, saturation_fraction = 1)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{CT}{Conservative Temperature [ degC ]}

\item{saturation_fraction}{fraction of air in water [unitless]}
}
\value{
pressure at which freezing will occur [ dbar ]
}
\description{
Pressure at which Seawater Freezes
}
\details{
The present R function works with a wrapper to a C function contained
within the GSW-C system (Version 3.05 dated 2017-07-27, available at
\url{https://github.com/TEOS-10/GSW-C},
as git commit '13ab33cea0e9059d3b3f3dfef78e9591c94af9f8'), which
stems from the GSW-Fortran system (\url{https://github.com/TEOS-10/GSW-Fortran})
which in turn stems from the GSW-Matlab system
(\url{https://github.com/TEOS-10/GSW-Matlab}).
Consult \url{http://www.teos-10.org} to learn more about
these software systems, their authorships, and the science behind
it all.
}
\examples{
SA <- c(                 34.7118, 34.8915, 35.0256, 34.8472, 34.7366, 34.7324)
CT <- c(                 -1.8996, -1.9407, -2.0062, -2.0923, -2.3593, -2.6771)
saturation_fraction <- c(       1,    0.8,     0.6,     0.5,     0.4,       0)
p <- gsw_pressure_freezing_CT(SA, CT, saturation_fraction)
expect_equal(p/1e3, c(0.009890530270710, 0.050376026585933, 0.125933117050624,
                    0.251150973076077, 0.601441775836021, 1.002273338145043))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_pressure_freezing_CT.html}
}
