% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_pt_from_t_ice}
\alias{gsw_pt_from_t_ice}
\title{Potential Temperature of Ice from in-situ Temperature}
\usage{
gsw_pt_from_t_ice(t, p, p_ref = 0)
}
\arguments{
\item{t}{in-situ temperature (ITS-90) [ degC ]}

\item{p}{sea pressure [dbar], i.e. absolute pressure [dbar] minus 10.1325 dbar}

\item{p_ref}{reference pressure [ dbar ]}
}
\value{
potential temperature [ degC ]
}
\description{
Potential Temperature of Ice from in-situ Temperature
}
\details{
The present R function works with a wrapper to a C function contained
within the GSW-C system (Version 3.05-4 dated 2017-08-07, available at
\url{https://github.com/TEOS-10/GSW-C},
as git commit '5b4d959e54031f9e972f3e863f63e67fa4f5bfec'), which
stems from the GSW-Fortran system (\url{https://github.com/TEOS-10/GSW-Fortran})
which in turn stems from the GSW-Matlab system
(\url{https://github.com/TEOS-10/GSW-Matlab}).
Consult \url{http://www.teos-10.org} to learn more about
these software systems, their authorships, and the science behind
it all.
}
\examples{
t <- c(-10.7856, -13.4329, -12.8103, -12.2600, -10.8863, -8.4036)
p <- c(      10,       50,      125,      250,      600,    1000)
p_ref <- 0 # not actually needed, since 0 is the default
pt <- gsw_pt_from_t_ice(t, p, p_ref)
expect_equal(pt, c(-10.787787898205272, -13.443730926050661, -12.837427056999676,
                 -12.314321615760921, -11.017040858094234, -8.622907355083147))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_pt_from_t_ice.html}
}
