% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_t_freezing_first_derivatives}
\alias{gsw_t_freezing_first_derivatives}
\title{Derivatives of Freezing Water Properties}
\usage{
gsw_t_freezing_first_derivatives(SA, p, saturation_fraction = 1)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{p}{sea pressure [dbar], i.e. absolute pressure [dbar] minus 10.1325 dbar}

\item{saturation_fraction}{fraction of air in water [unitless]}
}
\value{
a list containing \code{tfreezing_SA} [ K/(g/kg) ], the derivative of freezing
temperature with Absolute Salinity and
\code{tfreezing_p} [ K/dbar ], the derivative with respect to pressure.
}
\description{
Derivatives of Freezing Water Properties
}
\details{
The present R function works with a wrapper to a C function contained
within the GSW-C system (Version 3.05-4 dated 2017-08-07, available at
\url{https://github.com/TEOS-10/GSW-C},
as git commit '5b4d959e54031f9e972f3e863f63e67fa4f5bfec'), which
stems from the GSW-Fortran system (\url{https://github.com/TEOS-10/GSW-Fortran})
which in turn stems from the GSW-Matlab system
(\url{https://github.com/TEOS-10/GSW-Matlab}).
Consult \url{http://www.teos-10.org} to learn more about
these software systems, their authorships, and the science behind
it all.
}
\examples{
SA <- c(               34.7118, 34.8915, 35.0256, 34.8472, 34.7366, 34.7324)
p <- c(                     10,      50,     125,     250,     600,    1000)
saturation_fraction <- c(    1,     0.8,     0.6,     0.5,     0.4,       0)
derivs <- gsw_t_freezing_first_derivatives(SA, p, saturation_fraction)
expect_equal(derivs$tfreezing_SA, c(-0.056811800705787, -0.056856999671114, -0.056903079789292,
                                  -0.056904020028541, -0.056974588411844, -0.057082363270642))
expect_equal(derivs$tfreezing_p/1e-7, c(-0.748468312442338, -0.749793159537290, -0.752225023995510,
                                      -0.756170965034610, -0.767279572670040, -0.779936552091913))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_t_freezing_first_derivatives.html}
}
