% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_columns.R
\name{cols_align}
\alias{cols_align}
\title{Set the alignment of columns}
\usage{
cols_align(
  data,
  align = c("auto", "left", "center", "right"),
  columns = everything()
)
}
\arguments{
\item{data}{\emph{The gt table data object}

\verb{obj:<gt_tbl>} // \strong{required}

This is the \strong{gt} table object that is commonly created through use of the
\code{\link[=gt]{gt()}} function.}

\item{align}{\emph{Alignment type}

\verb{singl-kw:[auto|left|center|right]} // \emph{default:} \code{"auto"}

This can be any of \code{"center"}, \code{"left"}, or \code{"right"} for center-, left-,
or right-alignment. Alternatively, the \code{"auto"} option (the default), will
automatically align values in columns according to the data type (see the
Details section for specifics on which alignments are applied).}

\item{columns}{\emph{Columns to target}

\verb{<column-targeting expression>} // \emph{default:} \code{everything()}

The columns for which the alignment should be applied. Can either be a
series of column names provided in \code{\link[=c]{c()}}, a vector of column indices, or a
select helper function. Examples of select helper functions include
\code{\link[=starts_with]{starts_with()}}, \code{\link[=ends_with]{ends_with()}}, \code{\link[=contains]{contains()}}, \code{\link[=matches]{matches()}}, \code{\link[=one_of]{one_of()}},
\code{\link[=num_range]{num_range()}}, and \code{\link[=everything]{everything()}}. By default this is set to \code{\link[=everything]{everything()}}
which means that the chosen alignment affects all columns.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
The individual alignments of columns (which includes the column labels and
all of their data cells) can be modified. We have the option to align text to
the \code{left}, the \code{center}, and the \code{right}. In a less explicit manner, we can
allow \strong{gt} to automatically choose the alignment of each column based on
the data type (with the \code{auto} option).
}
\details{
When you create a \strong{gt} table object using \code{\link[=gt]{gt()}}, automatic alignment of
column labels and their data cells is performed. By default, left-alignment
is applied to columns of class \code{character}, \code{Date}, or \code{POSIXct};
center-alignment is for columns of class \code{logical}, \code{factor}, or \code{list}; and
right-alignment is used for the \code{numeric} and \code{integer} columns.
}
\section{Examples}{


Let's use \code{\link{countrypops}} to create a small \strong{gt} table. We can change the
alignment of the \code{population} column with \code{cols_align()}. In this example,
the label and body cells of \code{population} will be aligned to the left.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{countrypops |>
  dplyr::select(-contains("code")) |>
  dplyr::filter(country_name == "San Marino") |>
  dplyr::slice_tail(n = 5) |>
  gt(rowname_col = "year", groupname_col = "country_name") |>
  cols_align(
    align = "left",
    columns = population
  )
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_cols_align_1.png" alt="This image of a table was generated from the first code example in the `cols_align()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

5-1
}

\section{Function Introduced}{

\code{v0.2.0.5} (March 31, 2020)
}

\seealso{
Other column modification functions: 
\code{\link{cols_add}()},
\code{\link{cols_align_decimal}()},
\code{\link{cols_hide}()},
\code{\link{cols_label_with}()},
\code{\link{cols_label}()},
\code{\link{cols_merge_n_pct}()},
\code{\link{cols_merge_range}()},
\code{\link{cols_merge_uncert}()},
\code{\link{cols_merge}()},
\code{\link{cols_move_to_end}()},
\code{\link{cols_move_to_start}()},
\code{\link{cols_move}()},
\code{\link{cols_nanoplot}()},
\code{\link{cols_unhide}()},
\code{\link{cols_units}()},
\code{\link{cols_width}()}
}
\concept{column modification functions}
