% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{currency}
\alias{currency}
\title{Supply a custom currency symbol to \code{fmt_currency()}}
\usage{
currency(..., .list = list2(...))
}
\arguments{
\item{...}{One or more named arguments using output contexts as the names and
currency symbol text as the values.}

\item{.list}{Allows for the use of a list as an input alternative to \code{...}.}
}
\value{
A list object of class \code{gt_currency}.
}
\description{
The \code{currency()} helper function makes it easy to specify a context-aware
currency symbol to \code{currency} argument of \code{\link[=fmt_currency]{fmt_currency()}}. Since \strong{gt} can
render tables to several output formats, \code{currency()} allows for different
variations of the custom symbol based on the output context (which are
\code{html}, \code{latex}, \code{rtf}, and \code{default}). The number of decimal places for
the custom currency defaults to \code{2}, however, a value set for the \code{decimals}
argument of \code{\link[=fmt_currency]{fmt_currency()}} will take precedence.
}
\details{
We can use any combination of \code{html}, \code{latex}, \code{rtf}, and \code{default} as named
arguments for the currency text in each of the namesake contexts. The
\code{default} value is used as a fallback when there doesn't exist a dedicated
currency text value for a particular output context (e.g., when a table is
rendered as HTML and we use \code{currency(latex = "LTC", default = "ltc")}, the
currency symbol will be \code{"ltc"}. For convenience, if we provide only a single
string without a name, it will be taken as the \code{default} (i.e.,
\code{currency("ltc")} is equivalent to \code{currency(default = "ltc")}). However, if
we were to specify currency strings for multiple output contexts, names are
required each and every context.
}
\section{Figures}{

\if{html}{\figure{man_currency_1.png}{options: width=100\%}}
}

\section{Function ID}{

7-14
}

\examples{
# Use `exibble` to create a gt table;
# format the `currency` column to have
# currency values in guilder (a defunct
# Dutch currency)
tab_1 <-
  exibble \%>\%
  gt() \%>\%
  fmt_currency(
    columns = vars(currency),
    currency = currency(
      html = "&fnof;",
      default = "f"),
    decimals = 2
  )

}
\seealso{
Other Helper Functions: 
\code{\link{adjust_luminance}()},
\code{\link{cell_borders}()},
\code{\link{cell_fill}()},
\code{\link{cell_text}()},
\code{\link{cells_body}()},
\code{\link{cells_column_labels}()},
\code{\link{cells_column_spanners}()},
\code{\link{cells_grand_summary}()},
\code{\link{cells_row_groups}()},
\code{\link{cells_stubhead}()},
\code{\link{cells_stub}()},
\code{\link{cells_summary}()},
\code{\link{cells_title}()},
\code{\link{default_fonts}()},
\code{\link{escape_latex}()},
\code{\link{google_font}()},
\code{\link{gt_latex_dependencies}()},
\code{\link{html}()},
\code{\link{md}()},
\code{\link{pct}()},
\code{\link{px}()},
\code{\link{random_id}()}
}
\concept{Helper Functions}
