% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{sp500}
\alias{sp500}
\title{Daily S&P 500 Index data from 1950 to 2015}
\format{
A tibble with 16607 rows and 7 variables:
\describe{
\item{date}{The date expressed as \code{Date} values}
\item{open, high, low, close}{The day's opening, high, low, and closing
prices in USD; the \code{close} price is adjusted for splits}
\item{volume}{the number of trades for the given \code{date}}
\item{adj_close}{The close price adjusted for both dividends and splits}
}
}
\usage{
sp500
}
\description{
This dataset provides daily price indicators for the S&P 500 index from the
beginning of 1950 to the end of 2015. The index includes 500 leading
companies and captures about 80\\% coverage of available market capitalization.
}
\section{Function ID}{

11-4
}

\examples{
# Here is a glimpse at the data
# available in `sp500`
dplyr::glimpse(sp500)

}
\seealso{
Other Datasets: 
\code{\link{countrypops}},
\code{\link{exibble}},
\code{\link{gtcars}},
\code{\link{pizzaplace}},
\code{\link{sza}}
}
\concept{Datasets}
\keyword{datasets}
