% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny.R
\name{gt_output}
\alias{gt_output}
\title{Create a \strong{gt} display table output element for Shiny}
\usage{
gt_output(outputId)
}
\arguments{
\item{outputId}{An output variable from which to read the table.}
}
\description{
Using \code{gt_output()} we can render a reactive \strong{gt} table, a process
initiated by using the \code{\link[=render_gt]{render_gt()}} function in the \code{server} component of a
Shiny app. The \code{gt_output()} call is to be used in the Shiny \code{ui} component,
the position and context wherein this call is made determines the where the
\strong{gt} table is rendered on the app page. It's important to note that the
ID given during the \code{\link[=render_gt]{render_gt()}} call is needed as the \code{outputId} in
\code{gt_output()} (e.g., \strong{server}: \verb{output$<id> <- render_gt(...)}; \strong{ui}:
\verb{gt_output(outputId = "<id>"}).
}
\details{
We need to ensure that we have the \strong{shiny} package installed first. This
is easily by using \code{install.packages("shiny")}. More information on creating
Shiny apps can be found at the \href{https://shiny.rstudio.com}{Shiny Site}.
}
\section{Function ID}{

12-2
}

\examples{
library(shiny)

# Here is a Shiny app (contained within
# a single file) that (1) prepares a
# gt table, (2) sets up the `ui` with
# `gt_output()`, and (3) sets up the
# `server` with a `render_gt()` that
# uses the `gt_tbl` object as the input
# expression

gt_tbl <-
  gtcars \%>\%
  gt() \%>\%
  cols_hide(contains("_"))

ui <- fluidPage(

  gt_output(outputId = "table")
)

server <- function(input,
                   output,
                   session) {

  output$table <-
    render_gt(
      expr = gt_tbl,
      height = px(600),
      width = px(600)
    )
}

if (interactive()) {
  shinyApp(ui, server)
}

}
\seealso{
Other Shiny functions: 
\code{\link{render_gt}()}
}
\concept{Shiny functions}
