% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_group.R
\name{grp_add}
\alias{grp_add}
\title{Add one or more \strong{gt} tables to a \code{gt_group} container object}
\usage{
grp_add(.data, ..., .list = list2(...), .before = NULL, .after = NULL)
}
\arguments{
\item{.data}{A \code{gt_group} container object, typically generated through use
of the \code{\link[=gt_group]{gt_group()}} function along with one or more \code{gt_tbl} objects.}

\item{...}{One or more \strong{gt} table (\code{gt_tbl}) objects, typically generated
via the \code{\link[=gt]{gt()}} function.}

\item{.list}{Allows for the use of a list as an input alternative to \code{...}.}

\item{.before, .after}{A single index for either \code{.before} or \code{.after},
specifying where the supplied \code{gt_tbl} objects should be placed amongst the
existing collection of \strong{gt} tables. If nothing is provided for either
argument the incoming \code{gt_tbl} objects will be appended.}
}
\value{
An object of class \code{gt_group}.
}
\description{
Should you have a \code{gt_group} object, created through use of the \code{\link[=gt_group]{gt_group()}}
function, you might want to add more \strong{gt} tables to that container. While
it's common to generate a \code{gt_group} object with a collection of \code{gt_tbl}
objects, one can also create an 'empty' \code{gt_group} object. Whatever your
workflow might be, the \code{grp_add()} function makes it possible to flexibly
add one or more new \strong{gt} tables, returning a refreshed \code{gt_group} object.
}
\section{Function ID}{

14-4
}

\section{Function Introduced}{

\emph{In Development}
}

\seealso{
Other table group functions: 
\code{\link{grp_clone}()},
\code{\link{grp_options}()},
\code{\link{grp_pull}()},
\code{\link{grp_replace}()},
\code{\link{grp_rm}()},
\code{\link{gt_group}()},
\code{\link{gt_split}()}
}
\concept{table group functions}
