% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_sample_datasets.R
\name{get_sample_datasets}
\alias{get_sample_datasets}
\title{Get Sample (Datasets)}
\usage{
get_sample_datasets(
  datasetId = "gtex_v8",
  sampleIds = NULL,
  tissueSampleIds = NULL,
  subjectIds = NULL,
  ageBrackets = NULL,
  sex = NULL,
  pathCategory = NULL,
  tissueSiteDetailIds = NULL,
  aliquotIds = NULL,
  autolysisScores = NULL,
  hardyScales = NULL,
  ischemicTimes = NULL,
  ischemicTimeGroups = NULL,
  rins = NULL,
  uberonIds = NULL,
  dataTypes = NULL,
  sortBy = "sampleId",
  sortDirection = "asc",
  page = 0,
  itemsPerPage = getOption("gtexr.itemsPerPage"),
  .verbose = getOption("gtexr.verbose"),
  .return_raw = FALSE
)
}
\arguments{
\item{datasetId}{String. Unique identifier of a dataset. Usually includes a
data source and data release. Options: "gtex_v8", "gtex_snrnaseq_pilot".}

\item{sampleIds}{Character vector. GTEx sample ID.}

\item{tissueSampleIds}{Array of strings. A list of Tissue Sample ID(s).}

\item{subjectIds}{Character vector. GTEx subject ID.}

\item{ageBrackets}{The age bracket(s) of the donors of interest. Options:
"20-29", "30-39", "40-49", "50-59", "60-69", "70-79".}

\item{sex}{String. Options: "male", "female".}

\item{pathCategory}{Character vector. Options: "adenoma", "amylacea",
"atelectasis", "atherosclerosis", "atherosis", "atrophy", "calcification",
"cirrhosis", "clean_specimens", "congestion", "corpora_albicantia", "cyst",
"desquamation", "diabetic", "dysplasia", "edema", "emphysema",
"esophagitis", "fibrosis", "gastritis", "glomerulosclerosis", "goiter",
"gynecomastoid", "hashimoto", "heart_failure_cells", "hemorrhage",
"hepatitis", "hyalinization", "hypereosinophilia", "hyperplasia",
"hypertrophy", "hypoxic", "infarction", "inflammation", "ischemic_changes",
"macrophages", "mastopathy", "metaplasia", "monckeberg", "necrosis",
"nephritis", "nephrosclerosis", "no_abnormalities", "nodularity",
"pancreatitis", "pigment", "pneumonia", "post_menopausal", "prostatitis",
"saponification", "scarring", "sclerotic", "solar_elastosis",
"spermatogenesis", "steatosis", "sweat_glands", "tma".}

\item{tissueSiteDetailIds}{Character vector of IDs for tissues of interest.
Can be GTEx specific IDs (e.g. "Whole_Blood"; use
\code{\link[=get_tissue_site_detail]{get_tissue_site_detail()}} to see valid values) or Ontology IDs.}

\item{aliquotIds}{Character vector.}

\item{autolysisScores}{Character vector. Options: "None", "Mild", "Moderate",
"Severe".}

\item{hardyScales}{Character vector. A list of Hardy Scale(s) of interest.
Options: "Ventilator case", "Fast death - violent", "Fast death - natural
causes", "Intermediate death", "Slow death".}

\item{ischemicTimes}{Integer.}

\item{ischemicTimeGroups}{Character vector. Options:
"<= 0", "1 - 300", "301 - 600", "601 - 900", "901 - 1200", "1201 - 1500", "> 1500".}

\item{rins}{Integer, vector.}

\item{uberonIds}{Character vector of Uberon IDs (e.g. "UBERON:EFO_0000572";
use \code{\link[=get_tissue_site_detail]{get_tissue_site_detail()}} to see valid values).}

\item{dataTypes}{Character vector. Options: "RNASEQ", "WGS", "WES", "OMNI",
"EXCLUDE".}

\item{sortBy}{String. Options: "sampleId", "ischemicTime", "aliquotId",
"tissueSampleId", "hardyScale", "pathologyNotes", "ageBracket",
"tissueSiteDetailId", "sex".}

\item{sortDirection}{String. Options: "asc", "desc". Default = "asc".}

\item{page}{Integer (default = 0).}

\item{itemsPerPage}{Integer (default = 250). Set globally to maximum value
100000 with \code{options(list(gtexr.itemsPerPage = 100000))}.}

\item{.verbose}{Logical. If \code{TRUE} (default), print paging information. Set
to \code{FALSE} globally with \code{options(list(gtexr.verbose = FALSE))}.}

\item{.return_raw}{Logical. If \code{TRUE}, return the raw API JSON response.
Default = \code{FALSE}}
}
\value{
A tibble. Or a list if \code{.return_raw = TRUE}.
}
\description{
This service returns information of samples used in analyses
from all datasets. Results may be filtered by dataset ID, sample ID, subject
ID, sample metadata, or other provided parameters. By default, this service
queries the latest GTEx release.

\href{https://gtexportal.org/api/v2/redoc#tag/Datasets-Endpoints/operation/get_sample_api_v2_dataset_sample_get}{GTEx Portal API documentation}
}
\examples{
\dontrun{
get_sample_datasets()
}
}
\seealso{
Other Datasets Endpoints: 
\code{\link{get_annotation}()},
\code{\link{get_collapsed_gene_model_exon}()},
\code{\link{get_downloads_page_data}()},
\code{\link{get_file_list}()},
\code{\link{get_full_get_collapsed_gene_model_exon}()},
\code{\link{get_functional_annotation}()},
\code{\link{get_linkage_disequilibrium_by_variant_data}()},
\code{\link{get_linkage_disequilibrium_data}()},
\code{\link{get_subject}()},
\code{\link{get_tissue_site_detail}()},
\code{\link{get_variant}()},
\code{\link{get_variant_by_location}()}
}
\concept{Datasets Endpoints}
