% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{cpp_snap_points_nearest2}
\alias{cpp_snap_points_nearest2}
\title{Snap points to the closest points from another set}
\usage{
cpp_snap_points_nearest2(data, ref, spatial_resolution)
}
\arguments{
\item{data}{A set of points to be snapped (a matrix). The result will have
the same number of rows of this argument. Each row will return the respective
snapped point.}

\item{ref}{A set of reference points (another matrix). The result will be 
a subset of this parameter.}

\item{spatial_resolution}{The spatial resolution of data, which means that from each
point of data it is possible to reach at least one point within data with distance 
equals or less than spatial_resolution.}
}
\value{
A data.frame with the snapped points.
}
\description{
Snap a set of points to the closest reference points.
It requires that the distance from the data points to the reference
points should be smaller than the spatial resolution and that such distance
should be smaller than the distance to the next reference point.
}
