% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_gtfs.R
\name{write_gtfs}
\alias{write_gtfs}
\title{Write GTFS data into a zip file}
\usage{
write_gtfs(gtfs, zipfile, overwrite = TRUE, quiet = FALSE)
}
\arguments{
\item{gtfs}{A GTFS data set stored in memory as a list of data.tables/data.frames.}

\item{zipfile}{The pathname of a .zip file to be saved with the GTFS data.}

\item{overwrite}{A logical. Whether to overwrite an existing \code{.zip} file.
Defaults to \code{TRUE}.}

\item{quiet}{A logical. Whether to hide log messages and progress bars. 
Defaults to \code{TRUE}.}
}
\value{
The status value returned by the external zip command, invisibly.
}
\description{
Write GTFS stored in memory as a list of data.tables into a zipped GTFS feed.
This function overwrites the zip file if it exists.
}
\examples{
library(dplyr)

# read a gtfs.zip to memory
poa <- read_gtfs(system.file("extdata/poa.zip", package = "gtfs2gps")) \%>\%
  filter_by_shape_id("T2-1") \%>\%
  filter_single_trip()

# write GTFS data into a zip file
write_gtfs(poa, paste0(tempdir(), "/mypoa.zip"))

}
